/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.message.callstack;

import io.etrace.agent.message.callstack.CallstackProducer;
import io.etrace.agent.message.manager.MultiMessageManager;
import io.etrace.common.message.MessageManager;
import io.etrace.common.modal.RedisResponse;
import io.etrace.common.modal.Transaction;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MultiCallstackProducer
extends CallstackProducer {
    private Stack<Transaction> transactions;
    private Lock lock = new ReentrantLock();

    private MultiCallstackProducer(MessageManager messageManager) {
        super(messageManager);
        this.transactions = new Stack();
    }

    public static MultiCallstackProducer createProducer() {
        MultiMessageManager multiMessageManager = MultiMessageManager.createManager();
        return new MultiCallstackProducer(multiMessageManager);
    }

    public static MultiCallstackProducer createIsolatedProducer() {
        MultiMessageManager multiMessageManager = MultiMessageManager.createManager();
        multiMessageManager.setIsolated(true);
        return new MultiCallstackProducer(multiMessageManager);
    }

    public void startTransaction(String type, String name) {
        this.startTransactionAndGet(type, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction startTransactionAndGet(String type, String name) {
        this.lock.lock();
        try {
            Transaction t = this.newTransaction(type, name);
            this.transactions.push(t);
            Transaction transaction = t;
            return transaction;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTag(String key, String value) {
        this.lock.lock();
        try {
            Transaction t;
            if (!this.transactions.isEmpty() && (t = this.transactions.peek()) != null) {
                t.addTag(key, value);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setTransactionStatus(Throwable throwable) {
        this.lock.lock();
        try {
            this.setTransactionStatus(throwable.getClass().getName());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setTransactionStatus(String status) {
        this.lock.lock();
        try {
            Transaction t;
            if (!this.transactions.isEmpty() && (t = this.transactions.peek()) != null) {
                t.setStatus(status);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void completeTransaction() {
        this.lock.lock();
        try {
            Transaction t;
            if (!this.transactions.isEmpty() && (t = this.transactions.pop()) != null) {
                t.complete();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void completeAllTransaction() {
        while (!this.transactions.isEmpty()) {
            this.completeTransaction();
        }
    }

    @Override
    public void clean() {
        this.lock.lock();
        try {
            this.transactions.clear();
            super.clean();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void redis(String url, String command, long duration, boolean succeed, String redisType) {
        super.redis(url, command, duration, succeed, null, redisType);
    }

    public void redis(String url, String command, long duration, boolean succeed, RedisResponse response, String redisType) {
        super.redis(url, command, duration, succeed, new RedisResponse[]{response}, redisType);
    }
}

