/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.message.callstack;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslatorThreeArg;
import com.lmax.disruptor.TimeoutException;
import io.etrace.agent.config.AgentConfiguration;
import io.etrace.agent.io.MessageSender;
import io.etrace.agent.message.QueueContext;
import io.etrace.agent.message.callstack.CallstackEvent;
import io.etrace.agent.stat.CallstackStats;
import io.etrace.common.modal.CallStackV1;
import io.etrace.common.modal.JSONCodecV1;
import io.etrace.common.modal.Message;
import io.etrace.common.util.ThreadUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CallstackQueue {
    private static final String EMPTY = "-1";
    @Inject
    private MessageSender messageSender;
    @Inject
    private CallstackStats stats;
    private MessageProducer messageProducer;
    private QueueContext<CallstackEvent> context = new QueueContext();
    private ScheduledExecutorService executorService;
    public static final long PULL_INTERVAL_IN_MILLISECOND = TimeUnit.SECONDS.toMillis(2L);

    public CallstackQueue() {
        this.messageProducer = new MessageProducer();
        CallstackEvent.MessageEventFactory factory = new CallstackEvent.MessageEventFactory();
        int bufferSize = 1024;
        this.context.build("CallStack-Producer", bufferSize, new EventConsumer(), factory);
        this.executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("CallstackQueue-Timer-%d").build());
        this.executorService.scheduleAtFixedRate(() -> {
            if (this.context.getRingBuffer() != null) {
                this.context.getRingBuffer().tryPublishEvent((EventTranslatorThreeArg)this.messageProducer, (Object)EMPTY, (Object)EMPTY, null);
            }
        }, 0L, PULL_INTERVAL_IN_MILLISECOND, TimeUnit.MILLISECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    public void produce(String requestId, String rpcId, Message message) {
        if (!this.context.isActive()) {
            return;
        }
        this.stats.incTotalCount();
        if (!this.context.getRingBuffer().tryPublishEvent((EventTranslatorThreeArg)this.messageProducer, (Object)requestId, (Object)rpcId, (Object)message)) {
            this.stats.incLoss();
            ThreadUtil.sleep((long)0L);
        }
    }

    public int getQueueSize() {
        return this.context.getQueueSize();
    }

    public void shutdown() {
        try {
            this.context.setActive(false);
            this.context.getRingBuffer().tryPublishEvent((EventTranslatorThreeArg)this.messageProducer, (Object)EMPTY, (Object)EMPTY, null);
            this.context.getDisruptor().shutdown(2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.executorService.shutdown();
        this.messageSender.shutdown();
    }

    class EventConsumer
    implements EventHandler<CallstackEvent> {
        private JsonFactory jsonFactory;
        private ByteArrayOutputStream baos;
        private JsonGenerator generator;
        private int totalCount;
        private int maxSize = 0x200000;
        private int maxCount = 300;
        private long start = System.currentTimeMillis();

        public EventConsumer() {
            this.jsonFactory = new JsonFactory();
            this.baos = new ByteArrayOutputStream();
            try {
                this.generator = this.jsonFactory.createGenerator((OutputStream)this.baos, JsonEncoding.UTF8);
                this.generator.writeStartArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void onEvent(CallstackEvent event, long sequence, boolean endOfBatch) throws Exception {
            if (this.generator != null) {
                try {
                    CallStackV1 callStack = event.getCallStack();
                    if (callStack != null && !CallstackQueue.EMPTY.equals(callStack.getRequestId()) && !CallstackQueue.EMPTY.equals(callStack.getId()) && callStack.getMessage() != null) {
                        ++this.totalCount;
                        JSONCodecV1.encodeCallstackByArrayFormat((CallStackV1)callStack, (JsonGenerator)this.generator);
                        callStack.clear();
                    }
                }
                catch (Exception e) {
                    CallstackQueue.this.stats.incLoss(this.totalCount);
                    if (this.generator != null) {
                        this.generator.flush();
                        this.generator.close();
                    }
                    if (this.baos != null) {
                        this.totalCount = 0;
                        this.start = System.currentTimeMillis();
                        this.baos.reset();
                    }
                    try {
                        this.generator = this.jsonFactory.createGenerator((OutputStream)this.baos, JsonEncoding.UTF8);
                        this.generator.writeStartArray();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            long endTime = System.currentTimeMillis();
            if (this.totalCount >= this.maxCount || this.baos.size() >= this.maxSize || endTime - this.start >= 2000L || !CallstackQueue.this.context.isActive()) {
                this.flush();
            }
            event.clear();
        }

        private void flush() throws IOException {
            if (this.generator != null) {
                this.generator.writeEndArray();
                this.generator.flush();
                this.generator.writeStartArray();
            }
            if (this.baos != null && this.baos.size() > 0) {
                try {
                    if (this.totalCount > 0) {
                        CallstackQueue.this.messageSender.send(this.baos.toByteArray(), this.totalCount);
                    }
                }
                finally {
                    this.totalCount = 0;
                    this.start = System.currentTimeMillis();
                    this.baos.reset();
                }
            }
        }
    }

    class MessageProducer
    implements EventTranslatorThreeArg<CallstackEvent, String, String, Message> {
        MessageProducer() {
        }

        public void translateTo(CallstackEvent event, long sequence, String requestId, String messageId, Message message) {
            event.reset(AgentConfiguration.getAppId(), CallstackQueue.this.context.getHostIp(), CallstackQueue.this.context.getHostName(), requestId, messageId, message, AgentConfiguration.getExtraProperties());
        }
    }
}

