/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.message.callstack;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.etrace.agent.config.AgentConfiguration;
import io.etrace.agent.message.manager.DefaultMessageManager;
import io.etrace.common.message.MessageManager;
import io.etrace.common.modal.Event;
import io.etrace.common.modal.Heartbeat;
import io.etrace.common.modal.Message;
import io.etrace.common.modal.RedisResponse;
import io.etrace.common.modal.TraceContext;
import io.etrace.common.modal.Transaction;
import io.etrace.common.modal.impl.DummyEvent;
import io.etrace.common.modal.impl.DummyHeartbeat;
import io.etrace.common.modal.impl.DummyTransaction;
import io.etrace.common.modal.impl.EventImpl;
import io.etrace.common.modal.impl.HeartbeatImpl;
import io.etrace.common.modal.impl.TransactionImpl;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class CallstackProducer {
    protected static final Event DUMMY_EVENT = new DummyEvent();
    protected static final Transaction DUMMY_TRANSACTION = new DummyTransaction();
    protected static final Heartbeat DUMMY_HEARTBEAT = new DummyHeartbeat();
    private static AtomicLong sequence = new AtomicLong(0L);
    protected MessageManager messageManager;

    @Inject
    public CallstackProducer(MessageManager messageManager) {
        this.messageManager = messageManager;
    }

    public void logError(Throwable throwable) {
        this.logError(null, throwable, null);
    }

    public void logError(String message, Throwable throwable) {
        this.logError(message, throwable, null);
    }

    public void logError(String message, Throwable throwable, Map<String, String> tags) {
        if (!this.messageManager.getConfigManager().isEnabled()) {
            return;
        }
        if (!this.shouldLog(throwable)) {
            return;
        }
        try {
            Event event = throwable instanceof Error ? this.newEvent("Error", throwable.getClass().getName(), message, throwable) : (throwable instanceof RuntimeException ? this.newEvent("RuntimeException", throwable.getClass().getName(), message, throwable) : this.newEvent("Exception", throwable.getClass().getName(), message, throwable));
            event.setStatus("ERROR");
            this.addTagsToMessage(tags, (Message)event);
            event.complete();
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    private Event newEvent(String type, String name, String message, Throwable t) {
        if (!this.messageManager.getConfigManager().isEnabled()) {
            return DUMMY_EVENT;
        }
        if (!this.messageManager.hasContext()) {
            this.messageManager.setup();
        }
        EventImpl event = new EventImpl(type, name, message, t, this.messageManager);
        event.setId(sequence.incrementAndGet());
        return event;
    }

    public void logEvent(String type, String name, String status, String data, Map<String, String> tags) {
        if (!this.messageManager.getConfigManager().isEnabled()) {
            return;
        }
        Event event = this.newEvent(type, name, status);
        if (!Strings.isNullOrEmpty((String)status)) {
            event.setStatus(status);
        }
        event.setData(data);
        this.addTagsToMessage(tags, (Message)event);
        event.complete();
    }

    @Deprecated
    public Event newEvent(String type, String name) {
        return this.newEvent(type, name, "unset");
    }

    private Event newEvent(String type, String name, String status) {
        if (!this.messageManager.getConfigManager().isEnabled()) {
            return DUMMY_EVENT;
        }
        if (!this.messageManager.hasContext()) {
            this.messageManager.setup();
        }
        EventImpl event = new EventImpl(type, name, this.messageManager);
        event.setId(sequence.incrementAndGet());
        event.setStatus(status);
        return event;
    }

    public Transaction newTransaction(String type, String name) {
        if (!this.messageManager.getConfigManager().isEnabled()) {
            return DUMMY_TRANSACTION;
        }
        if (!this.messageManager.hasContext()) {
            this.messageManager.setup();
        }
        TransactionImpl transaction = new TransactionImpl(type, name, this.messageManager);
        if (AgentConfiguration.getGlobalTags() != null) {
            for (Map.Entry<String, String> entry : AgentConfiguration.getGlobalTags().entrySet()) {
                transaction.addTag(entry.getKey(), entry.getValue());
            }
        }
        this.messageManager.startTransaction((Transaction)transaction);
        transaction.setId(sequence.incrementAndGet());
        return transaction;
    }

    public void logHeartbeat(String type, String name, String status, String data, Map<String, String> tags) {
        if (!this.messageManager.getConfigManager().isEnabled()) {
            return;
        }
        Heartbeat heartbeat = this.newHeartbeat(type, name);
        heartbeat.setStatus(status);
        heartbeat.setData(data);
        if (tags != null) {
            heartbeat.addTags(tags);
        }
        heartbeat.complete();
    }

    public Heartbeat newHeartbeat(String type, String name) {
        if (!this.messageManager.getConfigManager().isEnabled()) {
            return DUMMY_HEARTBEAT;
        }
        if (!this.messageManager.hasContext()) {
            this.messageManager.setup();
        }
        HeartbeatImpl heartbeat = new HeartbeatImpl(type, name, this.messageManager);
        heartbeat.setId(sequence.incrementAndGet());
        this.addTagsToMessage(Collections.emptyMap(), (Message)heartbeat);
        return heartbeat;
    }

    public void shutdown() {
        this.messageManager.shutdown();
    }

    public String getCurrentRequestId() {
        return this.messageManager.getCurrentRequestId();
    }

    public String getCurrentRpcIdAndCurrentCall() {
        return this.messageManager.getCurrentRpcIdAndCurrentCall();
    }

    public String getRpcId() {
        return this.messageManager.getRpcId();
    }

    public void removeContext() {
        this.messageManager.removeContext();
    }

    public String nextLocalRpcId() {
        return this.messageManager.nextLocalRpcId();
    }

    public String nextRemoteRpcId() {
        return this.messageManager.nextRemoteRpcId();
    }

    public boolean hasContext() {
        return this.messageManager.hasContext();
    }

    public boolean hasTransaction() {
        return this.messageManager.hasTransaction();
    }

    public void clean() {
        this.messageManager.reset();
    }

    public void continueTrace(String requestId, String rpcId) {
        this.messageManager.setup(requestId, rpcId);
    }

    private boolean shouldLog(Throwable e) {
        return !(this.messageManager instanceof DefaultMessageManager) || ((DefaultMessageManager)this.messageManager).shouldLog(e);
    }

    public TraceContext exportContext() {
        return this.messageManager.exportContext();
    }

    public void importContext(TraceContext context) {
        this.messageManager.importContext(context);
    }

    public boolean isImportContext() {
        return this.messageManager.isImportContext();
    }

    public String getClientAppId() {
        return this.messageManager.getClientAppId();
    }

    @Deprecated
    public void redis(String url, String command, long duration, boolean succeed, RedisResponse[] responses, String redisType) {
    }

    private void addTagsToMessage(Map<String, String> tags, Message message) {
        if (tags != null) {
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                message.addTag(entry.getKey(), entry.getValue());
            }
        }
        if (AgentConfiguration.getGlobalTags() != null) {
            for (Map.Entry<String, String> entry : AgentConfiguration.getGlobalTags().entrySet()) {
                message.addTag(entry.getKey(), entry.getValue());
            }
        }
    }
}

