/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.message;

import io.etrace.agent.message.RandomString;
import java.util.UUID;

public class RequestIdAndRpcIdFactory {
    private RandomString randomString = new RandomString(32);

    public String getNextId() {
        return this.randomString.nextString();
    }

    @Deprecated
    public String getNextIdFromUUID() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    public static String parseClientAppIdFromOriginalRpcId(String rpcId) {
        int index = rpcId.indexOf("|");
        if (index > 0) {
            return rpcId.substring(0, index);
        }
        return "unknown";
    }

    public static String parseRpcIdFromOriginalRpcId(String rpcId) {
        int index = rpcId.indexOf("|");
        if (index > 0) {
            return rpcId.substring(index + 1);
        }
        return rpcId;
    }

    public static String buildNextLocalRpcId(String currentRpcId, String nextLocalThreadId) {
        return currentRpcId + "^" + nextLocalThreadId;
    }

    public static String buildNextRemoteRpcId(String rpcId, int currentCall) {
        return rpcId + "." + currentCall;
    }

    public static String buildTruncatedRpcId(String rpcId, int next) {
        return rpcId + "~" + next;
    }

    public static String buildRequestId(String rid, String appId) {
        int index = rid.indexOf("^^");
        if (index < 0) {
            int tsIndex = rid.lastIndexOf("|");
            if (tsIndex > 0) {
                return appId + "^^" + rid;
            }
            return appId + "^^" + rid + "|" + System.currentTimeMillis();
        }
        int tsIndex = rid.lastIndexOf("|");
        if (tsIndex < 0) {
            return rid + "|" + System.currentTimeMillis();
        }
        return rid;
    }
}

