/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.message;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.LiteBlockingWaitStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import io.etrace.agent.config.AgentConfiguration;
import io.etrace.common.util.NetworkInterfaceHelper;
import java.util.Map;

public class QueueContext<E> {
    private volatile boolean active = true;
    private String hostIp = NetworkInterfaceHelper.INSTANCE.getLocalHostAddress();
    private String hostName = NetworkInterfaceHelper.INSTANCE.getLocalHostName();
    private Map<String, String> extraProperties = AgentConfiguration.getExtraProperties();
    private Disruptor<E> disruptor;
    private RingBuffer<E> ringBuffer;

    public void build(String name, int bufferSize, EventHandler handler, EventFactory<E> factory) {
        this.disruptor = new Disruptor(factory, bufferSize, r -> {
            Thread t = new Thread(r);
            t.setName(name);
            t.setDaemon(true);
            return t;
        }, ProducerType.MULTI, (WaitStrategy)new LiteBlockingWaitStrategy());
        this.disruptor.handleEventsWith(new EventHandler[]{handler});
        this.disruptor.setDefaultExceptionHandler(new ExceptionHandler<E>(){

            public void handleEventException(Throwable ex, long sequence, E event) {
            }

            public void handleOnStartException(Throwable ex) {
            }

            public void handleOnShutdownException(Throwable ex) {
            }
        });
        this.ringBuffer = this.disruptor.getRingBuffer();
        this.disruptor.start();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getHostIp() {
        return this.hostIp;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Disruptor<E> getDisruptor() {
        return this.disruptor;
    }

    public RingBuffer<E> getRingBuffer() {
        return this.ringBuffer;
    }

    public int getQueueSize() {
        return this.ringBuffer.getBufferSize() - (int)this.ringBuffer.remainingCapacity();
    }

    public Map<String, String> getExtraProperties() {
        return this.extraProperties;
    }
}

