/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.io;

import io.etrace.agent.config.CollectorRegistry;
import io.etrace.agent.network.AbstractSocketClient;
import io.etrace.common.rpc.MessageService;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.thrift.TException;

public class Client
extends AbstractSocketClient {
    public Client() {
        this(5000);
    }

    public Client(int senderTimeout) {
        super(senderTimeout);
        this.useTcp = CollectorRegistry.getInstance().isUseTcp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean thriftSend(MessageService.Client client, byte[] head, byte[] chunk) {
        try {
            client.send(ByteBuffer.wrap(head), ByteBuffer.wrap(chunk));
            boolean bl = true;
            return bl;
        }
        catch (TException e) {
            this.closeConnection();
            boolean bl = false;
            return bl;
        }
        finally {
            if (!CollectorRegistry.getInstance().isLongConnection()) {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tcpSend(SocketChannel socketChannel, byte[] head, byte[] chunk) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(12 + head.length + chunk.length);
            buffer.putInt(8 + head.length + chunk.length);
            buffer.putInt(head.length);
            buffer.put(head);
            buffer.putInt(chunk.length);
            buffer.put(chunk);
            buffer.flip();
            while (buffer.hasRemaining() && socketChannel.write(buffer) != 0) {
            }
            buffer.compact();
            boolean bl = buffer.position() == 0;
            return bl;
        }
        catch (Throwable e) {
            this.closeConnection();
            boolean bl = false;
            return bl;
        }
        finally {
            if (!CollectorRegistry.getInstance().isLongConnection()) {
                this.closeConnection();
            }
        }
    }

    @Override
    public boolean send0(byte[] head, byte[] chunk) {
        Object client = this.getClient();
        if (null == client) {
            return false;
        }
        if (client instanceof SocketChannel) {
            return this.tcpSend((SocketChannel)client, head, chunk);
        }
        return this.thriftSend((MessageService.Client)client, head, chunk);
    }

    @Override
    public boolean openConnection() {
        this.getConnection();
        return this.isOpen();
    }

    private Object getClient() {
        this.openConnection();
        if (null == this.connection) {
            return null;
        }
        return this.connection.getSocketClient();
    }
}

