/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.config;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.etrace.agent.config.AgentConfiguration;
import io.etrace.agent.config.CollectorRegistry;
import io.etrace.common.message.ConfigManger;
import io.etrace.common.modal.AgentConfig;
import io.etrace.common.modal.CollectorItem;
import io.etrace.common.modal.metric.MetricConfig;
import io.etrace.common.util.JSONUtil;
import io.etrace.common.util.NetworkInterfaceHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultConfigManager
implements ConfigManger {
    private volatile AgentConfig agentConfig = DEFAULT_AGENT_CONFIOG;
    private volatile MetricConfig metricConfig = DEFAULT_METRIC_CONFIG;
    private ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Config-Fetch-Timer-%d").build());
    public static final long PULL_CONFIG_INTERVAL_IN_MILLISECOND = TimeUnit.MINUTES.toMillis(1L);

    public DefaultConfigManager() {
        this.executorService.scheduleAtFixedRate(this::init, 0L, PULL_CONFIG_INTERVAL_IN_MILLISECOND, TimeUnit.MILLISECONDS);
    }

    public void init() {
        this.pullMetricConfig();
        this.pullAgentConfig();
        this.pullCollectorList();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public MetricConfig getMetricConfig() {
        return this.metricConfig;
    }

    public AgentConfig getAgentConfig() {
        return this.agentConfig;
    }

    public boolean isEnabled() {
        return this.agentConfig.isEnabled() && !Strings.isNullOrEmpty((String)AgentConfiguration.getCollectorIp()) && CollectorRegistry.getInstance().isAvailable();
    }

    public boolean isAopEnabled() {
        return this.agentConfig.isAopEnabled();
    }

    public int getTagCount() {
        return this.agentConfig.getTagCount();
    }

    public int getTagSize() {
        return this.agentConfig.getTagSize();
    }

    public int getDataSize() {
        return this.agentConfig.getDataSize();
    }

    public int getMessageCount() {
        return this.agentConfig.getMessageCount();
    }

    public int getRedisSize() {
        if (this.agentConfig.getRedisSize() <= 0) {
            return 500;
        }
        return this.agentConfig.getRedisSize();
    }

    public void pullMetricConfig() {
        if (Strings.isNullOrEmpty((String)AgentConfiguration.getCollectorIp())) {
            return;
        }
        String url = this.getMetricConfigUrl();
        String configJson = this.getConfigFromHttp(url);
        if (!Strings.isNullOrEmpty((String)configJson)) {
            try {
                this.metricConfig = (MetricConfig)JSONUtil.toObject((String)configJson, MetricConfig.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void pullAgentConfig() {
        try {
            if (Strings.isNullOrEmpty((String)AgentConfiguration.getCollectorIp())) {
                return;
            }
            String collectorUrl = this.getCollectorHttpAgentConfigUrl();
            String configJson = this.getConfigFromHttp(collectorUrl);
            if (!Strings.isNullOrEmpty((String)configJson)) {
                try {
                    this.agentConfig = (AgentConfig)JSONUtil.toObject((String)configJson, AgentConfig.class);
                    CollectorRegistry.getInstance().setLongConnection(this.agentConfig.isLongConnection());
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullCollectorList() {
        if (Strings.isNullOrEmpty((String)AgentConfiguration.getCollectorIp())) {
            return;
        }
        try {
            String collectorUrl = this.getCollectorAddressUrl();
            String configJson = this.getConfigFromHttp(collectorUrl);
            if (!Strings.isNullOrEmpty((String)configJson)) {
                CollectorItem item = (CollectorItem)JSONUtil.toObject((String)configJson, CollectorItem.class);
                CollectorRegistry.getInstance().setCollectorItem(item);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (CollectorRegistry.getInstance().getCollectorsSize() < 1) {
                CollectorRegistry.getInstance().setIsAvailable(false);
            } else {
                CollectorRegistry.getInstance().setIsAvailable(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConfigFromHttp(String url) {
        InputStream contentInput = null;
        try {
            String line;
            URL onlineUrl = new URL(url);
            URLConnection onlineConn = onlineUrl.openConnection();
            onlineConn.setConnectTimeout(2000);
            onlineConn.setReadTimeout(2000);
            contentInput = onlineConn.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(contentInput));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String configJson = sb.toString();
            contentInput.close();
            contentInput = null;
            String string = configJson;
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (contentInput != null) {
                try {
                    contentInput.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private String getCollectorHttpAgentConfigUrl() {
        return String.format("http://%s:%d/agent-config?appId=%s&host=%s&hostName=%s", AgentConfiguration.getCollectorIp(), AgentConfiguration.getCollectorPort(), AgentConfiguration.getAppId(), NetworkInterfaceHelper.INSTANCE.getLocalHostAddress(), NetworkInterfaceHelper.INSTANCE.getLocalHostName());
    }

    private String getCollectorAddressUrl() {
        return String.format("http://%s:%d/collector/item?appId=%s&host=%s&hostName=%s", AgentConfiguration.getCollectorIp(), AgentConfiguration.getCollectorPort(), AgentConfiguration.getAppId(), NetworkInterfaceHelper.INSTANCE.getLocalHostAddress(), NetworkInterfaceHelper.INSTANCE.getLocalHostName());
    }

    private String getMetricConfigUrl() {
        return String.format("http://%s:%d/metric-config?appId=%s&host=%s&hostName=%s", AgentConfiguration.getCollectorIp(), AgentConfiguration.getCollectorPort(), AgentConfiguration.getAppId(), NetworkInterfaceHelper.INSTANCE.getLocalHostAddress(), NetworkInterfaceHelper.INSTANCE.getLocalHostName());
    }
}

