/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.config;

import io.etrace.common.message.ConfigManger;
import io.etrace.common.modal.Collector;
import io.etrace.common.modal.CollectorItem;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class CollectorRegistry {
    private final CollectorItem collectorItem = new CollectorItem(10);
    private final Pattern IP_PATTERN = Pattern.compile("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$");
    private AtomicLong collectorIndex = new AtomicLong(0L);
    private boolean longConnection = true;
    private volatile boolean isAvailable = true;
    private volatile boolean useTcp = false;
    private volatile boolean isInit = false;
    private ConfigManger configManger;

    public static CollectorRegistry getInstance() {
        return CollectorRegistryHolder.instance;
    }

    public void setCollectorItem(CollectorItem item) {
        if (null == item || this.collectorItem.equals((Object)item)) {
            return;
        }
        this.isInit = true;
        this.collectorItem.setUseTcp(item.isUseTcp());
        this.useTcp = this.collectorItem.isUseTcp();
        item.getTcpCollector().forEach(collector -> this.addCollector((Collector)collector, this.collectorItem.getTcpCollector()));
        item.getThriftCollector().forEach(collector -> this.addCollector((Collector)collector, this.collectorItem.getThriftCollector()));
        this.collectorItem.getTcpCollector().retainAll(item.getTcpCollector());
        this.collectorItem.getThriftCollector().retainAll(item.getThriftCollector());
        Collections.shuffle(this.collectorItem.getTcpCollector());
        Collections.shuffle(this.collectorItem.getThriftCollector());
    }

    private void addCollector(Collector collector, List<Collector> collectorList) {
        try {
            if (null == collector || null == collector.getIp() || !this.IP_PATTERN.matcher(collector.getIp()).matches() || collector.getPort() < 1 || collectorList.contains(collector)) {
                return;
            }
            collectorList.add(collector);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isLongConnection() {
        return this.longConnection;
    }

    public void setLongConnection(boolean longConnection) {
        this.longConnection = longConnection;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void setIsAvailable(boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    private void init() {
        if (!this.isInit) {
            this.configManger.init();
        }
    }

    public int getTcpCollectorSize() {
        this.init();
        return this.collectorItem.getTcpCollector().size();
    }

    public int getCollectorSize() {
        this.init();
        return this.collectorItem.getThriftCollector().size();
    }

    public Collector getTcpCollector() {
        if (this.collectorItem.getTcpCollector().isEmpty()) {
            return null;
        }
        long next = this.collectorIndex.getAndAdd(1L) % (long)this.collectorItem.getTcpCollector().size();
        return (Collector)this.collectorItem.getTcpCollector().get((int)next);
    }

    public Collector getThriftCollector() {
        if (this.collectorItem.getThriftCollector().isEmpty()) {
            return null;
        }
        long next = this.collectorIndex.getAndAdd(1L) % (long)this.collectorItem.getThriftCollector().size();
        return (Collector)this.collectorItem.getThriftCollector().get((int)next);
    }

    public int getCollectorsSize() {
        if (this.useTcp) {
            return this.collectorItem.getTcpCollector().size();
        }
        return this.collectorItem.getThriftCollector().size();
    }

    public boolean isUseTcp() {
        if (!this.isInit) {
            this.configManger.init();
        }
        return this.useTcp;
    }

    public void setConfigManger(ConfigManger configManger) {
        this.configManger = configManger;
    }

    private static class CollectorRegistryHolder {
        private static CollectorRegistry instance = new CollectorRegistry();

        private CollectorRegistryHolder() {
        }
    }
}

