/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.config;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.etrace.agent.config.ConfigurationLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AgentConfiguration {
    public static final String APPID_SYSTEM_PROPERTY_KEY = "APPID";
    public static final String COLLECTOR_IP_SYSTEM_PROPERTY_KEY = "COLLECTOR_IP";
    public static final String TENANT_SYSTEM_PROPERTY_KEY = "TENANT";
    private static volatile String appId = System.getProperty("APPID");
    private static volatile String collectorIp = System.getProperty("COLLECTOR_IP");
    private static volatile String tenant = System.getProperty("TENANT");
    private static volatile int port = 2890;
    private static volatile String instance;
    private static volatile Set<String> beanObjectNames;
    private static Map<String, String> globalTags;
    private static Map<String, String> extraProperties;

    public static void initByConfigurationLoader(ConfigurationLoader loader) {
        AgentConfiguration.setAppId(loader.getAppId());
        AgentConfiguration.setCollectorIp(loader.getCollectorDomainAndPort());
        AgentConfiguration.setTenant(loader.getTenant());
        AgentConfiguration.setInstance(loader.getInstance());
        AgentConfiguration.setGlobalTags(loader.getGlobalTags());
        AgentConfiguration.setExtraProperties(loader.getExtraProperties());
    }

    public static Map<String, String> getGlobalTags() {
        return globalTags;
    }

    public static void setGlobalTags(Map<String, String> tags) {
        if (tags != null) {
            globalTags = ImmutableMap.copyOf(tags);
        }
    }

    public static String getAppId() {
        return appId;
    }

    public static void setAppId(String appId) {
        AgentConfiguration.appId = !Strings.isNullOrEmpty((String)appId) ? appId : "unknown";
    }

    public static void setTenant(String tenant) {
        AgentConfiguration.tenant = tenant;
    }

    public static String getTenant() {
        return tenant;
    }

    public static String getCollectorIp() {
        return collectorIp;
    }

    public static void setCollectorIp(String collectorIp) {
        if (Strings.isNullOrEmpty((String)collectorIp)) {
            return;
        }
        if (!collectorIp.startsWith("http://")) {
            collectorIp = "http://" + collectorIp;
        }
        try {
            URL url = new URL(collectorIp);
            AgentConfiguration.collectorIp = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                return;
            }
            AgentConfiguration.port = url.getPort();
        }
        catch (MalformedURLException e) {
            AgentConfiguration.collectorIp = collectorIp;
        }
    }

    public static int getCollectorPort() {
        return port;
    }

    public static String getInstance() {
        return instance;
    }

    public static void setInstance(String instance) {
        if (instance != null && instance.length() > 50) {
            instance = instance.substring(0, 50);
        }
        AgentConfiguration.instance = instance;
    }

    public static Set<String> getBeanObjectNames() {
        return beanObjectNames;
    }

    public static Map<String, String> getExtraProperties() {
        return extraProperties;
    }

    public static void setExtraProperties(Map<String, String> extraProperties) {
        AgentConfiguration.extraProperties = extraProperties;
    }

    static {
        beanObjectNames = new HashSet<String>();
        globalTags = Maps.newHashMap();
    }
}

