/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent;

import com.google.inject.Injector;
import io.etrace.agent.config.AgentConfiguration;
import io.etrace.agent.io.MessageSender;
import io.etrace.agent.io.SocketClientFactory;
import io.etrace.agent.message.callstack.CallstackProducer;
import io.etrace.agent.message.callstack.CallstackQueue;
import io.etrace.agent.message.metric.MetricProducer;
import io.etrace.agent.module.InjectorFactory;
import io.etrace.agent.monitor.HeartbeatUploadTask;
import io.etrace.agent.stat.CallstackStats;
import io.etrace.common.modal.Event;
import io.etrace.common.modal.RedisResponse;
import io.etrace.common.modal.TraceContext;
import io.etrace.common.modal.Transaction;
import io.etrace.common.modal.metric.Counter;
import io.etrace.common.modal.metric.Gauge;
import io.etrace.common.modal.metric.Payload;
import io.etrace.common.modal.metric.Timer;
import java.util.Map;

public class Trace {
    private static Trace trace = new Trace();
    private CallstackProducer producer;
    private MetricProducer metricProducer;
    private CallstackQueue callstackQueue;
    private MessageSender tcpMessageSender;
    private HeartbeatUploadTask task;
    private CallstackStats callstackStats;

    private Trace() {
        Injector injector = InjectorFactory.getInjector();
        this.producer = (CallstackProducer)injector.getInstance(CallstackProducer.class);
        this.callstackQueue = (CallstackQueue)injector.getInstance(CallstackQueue.class);
        this.metricProducer = (MetricProducer)injector.getInstance(MetricProducer.class);
        this.tcpMessageSender = (MessageSender)injector.getInstance(MessageSender.class);
        this.callstackStats = (CallstackStats)injector.getInstance(CallstackStats.class);
        this.task = (HeartbeatUploadTask)injector.getInstance(HeartbeatUploadTask.class);
        this.task.startup();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Trace.shutdownTrace();
            SocketClientFactory.shutdown();
        }));
    }

    public static void shutdownTrace() {
        Trace.trace.task.shutdown();
        Trace.trace.producer.shutdown();
    }

    public static CallstackStats getStats() {
        return Trace.trace.callstackStats;
    }

    public static int getCallStackProducerQueueSize() {
        return Trace.trace.callstackQueue.getQueueSize();
    }

    public static int getTCPMessageSenderQueueSize() {
        return Trace.trace.tcpMessageSender.getQueueSize();
    }

    @Deprecated
    public static Event newEvent(String type, String name) {
        return Trace.trace.producer.newEvent(type, name);
    }

    public static void logEvent(String type, String name) {
        Trace.logEvent(type, name, "0");
    }

    public static void logEvent(String type, String name, String status) {
        Trace.logEvent(type, name, status, null);
    }

    public static void logEvent(String type, String name, String status, Map<String, String> tags) {
        Trace.logEvent(type, name, status, null, tags);
    }

    public static void logEvent(String type, String name, String status, String data, Map<String, String> tags) {
        Trace.trace.producer.logEvent(type, name, status, data, tags);
    }

    public static void logError(Throwable throwable) {
        Trace.logError(null, throwable);
    }

    public static void logError(Throwable throwable, Map<String, String> tags) {
        Trace.logError(null, throwable, tags);
    }

    public static void logError(String message, Throwable throwable) {
        Trace.logError(message, throwable, null);
    }

    public static void logError(String message, Throwable throwable, Map<String, String> tags) {
        Trace.trace.producer.logError(message, throwable, tags);
    }

    public static Transaction newTransaction(String type, String name) {
        return Trace.trace.producer.newTransaction(type, name);
    }

    public static boolean hasTransaction() {
        return Trace.trace.producer.hasTransaction();
    }

    public static void clean() {
        Trace.trace.producer.clean();
    }

    public static boolean hasContext() {
        return Trace.trace.producer.hasContext();
    }

    public static void continueTrace(String requestId, String rpcId) {
        Trace.trace.producer.continueTrace(requestId, rpcId);
    }

    public static String getCurrentRequestId() {
        return Trace.trace.producer.getCurrentRequestId();
    }

    public static String getRpcId() {
        return Trace.trace.producer.getRpcId();
    }

    public static String getCurrentRpcId() {
        return Trace.trace.producer.getRpcId();
    }

    public static String getCurrentRpcIdAndCurrentCall() {
        return Trace.trace.producer.getCurrentRpcIdAndCurrentCall();
    }

    public static void removeContext() {
        Trace.trace.producer.removeContext();
    }

    public static String getCurrentRpcIdWithAppId() {
        return AgentConfiguration.getAppId() + "|" + Trace.getCurrentRpcId();
    }

    public static String nextRemoteRpcId() {
        String nextRpcId = Trace.trace.producer.nextRemoteRpcId();
        Trace.logEvent("ETraceLink", "RemoteCall", "0", nextRpcId, null);
        return nextRpcId;
    }

    public static String nextLocalRpcId() {
        String nextRpcId = Trace.trace.producer.nextLocalRpcId();
        Trace.logEvent("ETraceLink", "AsyncCall", "0", nextRpcId, null);
        return nextRpcId;
    }

    public static String getClientAppId() {
        return Trace.trace.producer.getClientAppId();
    }

    public static TraceContext exportContext() {
        return Trace.trace.producer.exportContext();
    }

    public static void importContext(TraceContext context) {
        Trace.trace.producer.importContext(context);
    }

    public static boolean isImportContext() {
        return Trace.trace.producer.isImportContext();
    }

    @Deprecated
    public static void redis(String url, String command, long duration, boolean succeed) {
        Trace.trace.producer.redis(url, command, duration, succeed, null, null);
    }

    @Deprecated
    public static void redis(String url, String command, long duration, boolean succeed, String redisType) {
        Trace.trace.producer.redis(url, command, duration, succeed, null, redisType);
    }

    @Deprecated
    public static void redis(String url, String command, long duration, boolean succeed, RedisResponse response) {
        Trace.trace.producer.redis(url, command, duration, succeed, new RedisResponse[]{response}, null);
    }

    @Deprecated
    public static void redis(String url, String command, long duration, boolean succeed, RedisResponse response, String redisType) {
        Trace.trace.producer.redis(url, command, duration, succeed, new RedisResponse[]{response}, redisType);
    }

    @Deprecated
    public static void redis(String url, String command, long duration, boolean succeed, RedisResponse[] responses) {
        Trace.trace.producer.redis(url, command, duration, succeed, responses, null);
    }

    @Deprecated
    public static void redis(String url, String command, long duration, boolean succeed, RedisResponse[] responses, String redisType) {
        Trace.trace.producer.redis(url, command, duration, succeed, responses, redisType);
    }

    public static void logHeartbeat(String type, String name, String status, String data, Map<String, String> tags) {
        Trace.trace.producer.logHeartbeat(type, name, status, data, tags);
    }

    public static Counter newCounter(String name) {
        return Trace.trace.metricProducer.newCounter(name);
    }

    public static Gauge newGauge(String name) {
        return Trace.trace.metricProducer.newGauge(name);
    }

    public static Timer newTimer(String name) {
        return Trace.trace.metricProducer.newTimer(name);
    }

    public static Payload newPayload(String name) {
        return Trace.trace.metricProducer.newPayload(name);
    }
}

