/*
 * Copyright 2019 etrace.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.etrace.agent.message.event;

import com.lmax.disruptor.EventFactory;
import io.etrace.agent.message.metric.PackageMetric;
import io.etrace.common.modal.metric.MetricKey;

import java.util.Map;

public class MatricPackageEvent {
    private int sendCount;
    private Map<String, Map<MetricKey, PackageMetric>> metrics;

    public void reset(Map<String, Map<MetricKey, PackageMetric>> metrics, int sendCount) {
        this.metrics = metrics;
        this.sendCount = sendCount;
    }

    public Map<String, Map<MetricKey, PackageMetric>> getMetrics() {
        return metrics;
    }

    public int getSendCount() {
        return sendCount;
    }

    public void clear() {
        metrics = null;
        sendCount = 0;
    }

    public static class PackageEventFactory implements EventFactory<MatricPackageEvent> {
        @Override
        public MatricPackageEvent newInstance() {
            return new MatricPackageEvent();
        }
    }
}
