/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.util;

import esa.commons.StringUtils;

public final class UriUtils {
    public static String encode(String target) {
        return UriUtils.encode(target, true, true, false);
    }

    public static String encode(String target, boolean encodeSlashInPath, boolean encodePercentAnyway, boolean encodePercentCondition) {
        if (StringUtils.isEmpty((String)target)) {
            return target;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < target.length(); ++i) {
            char current = target.charAt(i);
            if ('/' == current) {
                if (encodeSlashInPath) {
                    sb.append("%2F");
                    continue;
                }
                sb.append(current);
                continue;
            }
            if ('%' == current) {
                if (encodePercentAnyway) {
                    sb.append("%25");
                    continue;
                }
                if (encodePercentCondition) {
                    if (i + 1 < target.length() && UriUtils.isHex(target.charAt(i + 1)) && i + 2 < target.length() && UriUtils.isHex(target.charAt(i + 2))) {
                        sb.append(current);
                        continue;
                    }
                    sb.append("%25");
                    continue;
                }
                sb.append(current);
                continue;
            }
            sb.append(current);
        }
        return sb.toString();
    }

    private static boolean isHex(char target) {
        if (target >= '0' && target <= '9') {
            return true;
        }
        if (target >= 'A' && target <= 'F') {
            return true;
        }
        return target >= 'a' && target <= 'f';
    }

    private UriUtils() {
    }
}

