/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.util;

import jakarta.ws.rs.core.MediaType;
import java.util.concurrent.ConcurrentHashMap;

public final class MediaTypeUtils {
    private static final ConcurrentHashMap<MediaType, ParseResult<io.esastack.commons.net.http.MediaType>> JAKARTA_TO_COMMON_CACHE = new ConcurrentHashMap(16);
    private static final ConcurrentHashMap<io.esastack.commons.net.http.MediaType, ParseResult<MediaType>> COMMON_TO_JAKARTA_CACHE = new ConcurrentHashMap(16);

    public static io.esastack.commons.net.http.MediaType convert(MediaType from) {
        if (from == null) {
            return null;
        }
        ParseResult result = JAKARTA_TO_COMMON_CACHE.get(from);
        if (result == null) {
            result = JAKARTA_TO_COMMON_CACHE.computeIfAbsent(from, key -> {
                try {
                    return ParseResult.ok(io.esastack.commons.net.http.MediaType.builder((String)key.getType(), (String)key.getSubtype()).addParams(key.getParameters()).build());
                }
                catch (Throwable th) {
                    return ParseResult.error(new IllegalArgumentException(th));
                }
            });
        }
        if (result.r != null) {
            return (io.esastack.commons.net.http.MediaType)result.r;
        }
        throw result.t;
    }

    public static MediaType convert(io.esastack.commons.net.http.MediaType from) {
        if (from == null) {
            return null;
        }
        ParseResult result = COMMON_TO_JAKARTA_CACHE.get(from);
        if (result == null) {
            result = COMMON_TO_JAKARTA_CACHE.computeIfAbsent(from, key -> {
                try {
                    return ParseResult.ok(new MediaType(key.type(), key.subtype(), key.params()));
                }
                catch (Throwable th) {
                    return ParseResult.error(new IllegalArgumentException(th));
                }
            });
        }
        if (result.r != null) {
            return (MediaType)result.r;
        }
        throw result.t;
    }

    private MediaTypeUtils() {
    }

    private static class ParseResult<T> {
        final T r;
        final IllegalArgumentException t;

        private ParseResult(T r, IllegalArgumentException t) {
            this.r = r;
            this.t = t;
        }

        static <T> ParseResult<T> ok(T r) {
            return new ParseResult<T>(r, null);
        }

        static <T> ParseResult<T> error(IllegalArgumentException t) {
            return new ParseResult<Object>(null, t);
        }
    }
}

