/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.util;

import esa.commons.ClassUtils;
import esa.commons.reflect.AnnotationUtils;
import esa.commons.reflect.ReflectionUtils;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.restlight.core.context.HttpResponse;
import io.esastack.restlight.core.handler.method.MethodParam;
import io.esastack.restlight.core.handler.method.Param;
import io.esastack.restlight.core.util.LoggerUtils;
import io.esastack.restlight.core.util.OrderedComparator;
import io.esastack.restlight.jaxrs.configure.OrderComponent;
import io.esastack.restlight.jaxrs.impl.core.ResponseImpl;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.NameBinding;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.RuntimeDelegate;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;

public final class JaxrsUtils {
    private static final boolean HAS_JAVAX_PRIORITY;

    public static int defaultOrder() {
        return 5000;
    }

    public static int getOrder(Object obj) {
        if (!HAS_JAVAX_PRIORITY) {
            return JaxrsUtils.defaultOrder();
        }
        Class userType = ClassUtils.getUserType((Object)obj);
        userType = userType.isSynthetic() ? userType.getSuperclass() : userType;
        Priority priority = userType.getAnnotation(Priority.class);
        if (priority == null) {
            return JaxrsUtils.defaultOrder();
        }
        return priority.value();
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        RuntimeDelegate.HeaderDelegate delegate = RuntimeDelegate.getInstance().createHeaderDelegate(ClassUtils.getUserType((Object)object));
        if (delegate != null) {
            return delegate.toString(object);
        }
        return object.toString();
    }

    public static MultivaluedMap<String, Object> convertToMap(HttpHeaders headers) {
        MultivaluedHashMap dest = new MultivaluedHashMap();
        if (headers == null) {
            return dest;
        }
        for (String name : headers.names()) {
            dest.addAll((Object)name, new ArrayList(headers.getAll(name)));
        }
        return dest;
    }

    public static void convertThenAddToHeaders(MultivaluedMap<String, Object> values, HttpHeaders headers) {
        if (values == null || values.isEmpty()) {
            return;
        }
        headers.clear();
        for (Map.Entry entry : values.entrySet()) {
            List value = (List)entry.getValue();
            if (value == null || value.isEmpty()) continue;
            headers.add((String)entry.getKey(), (Iterable)value.stream().map(JaxrsUtils::toString).collect(Collectors.toList()));
        }
    }

    public static void addMetadataToJakarta(HttpResponse from, ResponseImpl to) {
        if (from == null || to == null) {
            return;
        }
        if (!(from.entity() instanceof Response)) {
            to.setEntity(from.entity());
            to.setStatus(from.status());
        }
        for (Map.Entry entry : from.headers()) {
            to.getHeaders().add(entry.getKey(), entry.getValue());
        }
    }

    public static void addMetadataFromJakarta(ResponseImpl from, HttpResponse to) {
        if (from == null || to == null) {
            return;
        }
        to.status(from.getStatus());
        if (!(to.entity() instanceof Response)) {
            to.entity(from.getEntity());
        }
        to.headers().clear();
        MultivaluedMap<String, String> headers = from.getStringHeaders();
        for (String name : headers.keySet()) {
            to.headers().add(name, (Iterable)headers.get((Object)name));
        }
    }

    public static <K, V1, V2> boolean equalsIgnoreValueOrder(MultivaluedMap<K, V1> m1, MultivaluedMap<K, V2> m2) {
        if (m1 == null) {
            return m2 == null;
        }
        if (m2 == null) {
            return false;
        }
        if (m1.keySet().size() != m2.keySet().size()) {
            return false;
        }
        for (Map.Entry e : m1.entrySet()) {
            List olist2 = (List)m2.get(e.getKey());
            List olist1 = (List)e.getValue();
            if (olist1 == null) {
                return olist2 == null;
            }
            if (olist2 == null) {
                return false;
            }
            if (olist1.size() != olist2.size()) {
                return false;
            }
            for (Object v : olist1) {
                if (olist2.contains(v)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isServerSide(Class<?> clazz) {
        ConstrainedTo constrain = (ConstrainedTo)AnnotationUtils.findAnnotation(clazz, ConstrainedTo.class);
        return constrain == null || RuntimeType.SERVER == constrain.value();
    }

    public static boolean isPreMatched(Object obj) {
        return AnnotationUtils.hasAnnotation((AnnotatedElement)ClassUtils.getUserType((Object)obj), PreMatching.class);
    }

    public static boolean hasAnnotation(Param param, Class<? extends Annotation> target) {
        if (param == null || target == null) {
            return false;
        }
        return param.hasAnnotation(target) || JaxrsUtils.isSetterParam(param, target);
    }

    public static <T extends Annotation> T getAnnotation(Param param, Class<T> target) {
        if (param == null || target == null) {
            return null;
        }
        Annotation annotation = param.getAnnotation(target);
        if (annotation != null) {
            return (T)annotation;
        }
        if (param.isMethodParam()) {
            return (T)AnnotationUtils.findAnnotation((AnnotatedElement)param.methodParam().method(), target);
        }
        return null;
    }

    public static Set<Class<? extends Annotation>> findNameBindings(Method method, boolean alsoUseClass) {
        if (method == null) {
            return Collections.emptySet();
        }
        HashSet<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>(JaxrsUtils.findNameBindings(method));
        if (alsoUseClass) {
            annotations.addAll(JaxrsUtils.findNameBindings(method.getDeclaringClass()));
        }
        return annotations;
    }

    public static Set<Class<? extends Annotation>> findNameBindings(AnnotatedElement obj) {
        if (obj == null) {
            return Collections.emptySet();
        }
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>(obj.getDeclaredAnnotations().length);
        for (Annotation declaredAnn : obj.getDeclaredAnnotations()) {
            Class<? extends Annotation> type = declaredAnn.annotationType();
            if (type.getDeclaredAnnotation(NameBinding.class) == null) continue;
            result.add(type);
        }
        return result;
    }

    public static <T> List<T> ascendingOrdered(List<OrderComponent<T>> components) {
        OrderedComparator.sort(components);
        return components.stream().map(OrderComponent::underlying).collect(Collectors.toList());
    }

    public static <T> List<T> descendingOrder(List<OrderComponent<T>> components) {
        List<T> result = JaxrsUtils.ascendingOrdered(components);
        Collections.reverse(result);
        return result;
    }

    public static Map<Class<?>, Integer> extractContracts(Object obj, int defaultOrder) {
        return JaxrsUtils.extractContracts(ClassUtils.getUserType((Object)obj), defaultOrder);
    }

    public static boolean isRootResource(Class<?> clazz) {
        return AnnotationUtils.hasAnnotation(clazz, Path.class, (boolean)true);
    }

    public static boolean isMessageBodyReader(Class<?> clazz) {
        return MessageBodyReader.class.isAssignableFrom(clazz);
    }

    public static boolean isMessageBodyWriter(Class<?> clazz) {
        return MessageBodyWriter.class.isAssignableFrom(clazz);
    }

    public static boolean isContextResolver(Class<?> clazz) {
        return ContextResolver.class.isAssignableFrom(clazz);
    }

    public static boolean isExceptionMapper(Class<?> clazz) {
        return ExceptionMapper.class.isAssignableFrom(clazz);
    }

    public static boolean isFeature(Class<?> clazz) {
        return Feature.class.isAssignableFrom(clazz);
    }

    public static boolean isDynamicFeature(Class<?> clazz) {
        return DynamicFeature.class.isAssignableFrom(clazz);
    }

    public static boolean isRequestFilter(Class<?> clazz) {
        return ContainerRequestFilter.class.isAssignableFrom(clazz);
    }

    public static boolean isResponseFilter(Class<?> clazz) {
        return ContainerResponseFilter.class.isAssignableFrom(clazz);
    }

    public static boolean isReaderInterceptor(Class<?> clazz) {
        return ReaderInterceptor.class.isAssignableFrom(clazz);
    }

    public static boolean isWriterInterceptor(Class<?> clazz) {
        return WriterInterceptor.class.isAssignableFrom(clazz);
    }

    public static boolean isParamConverterProvider(Class<?> clazz) {
        return ParamConverterProvider.class.isAssignableFrom(clazz);
    }

    public static boolean isComponent(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return JaxrsUtils.isMessageBodyReader(clazz) || JaxrsUtils.isMessageBodyWriter(clazz) || JaxrsUtils.isContextResolver(clazz) || JaxrsUtils.isExceptionMapper(clazz) || JaxrsUtils.isFeature(clazz) || JaxrsUtils.isDynamicFeature(clazz) || JaxrsUtils.isRequestFilter(clazz) || JaxrsUtils.isResponseFilter(clazz) || JaxrsUtils.isReaderInterceptor(clazz) || JaxrsUtils.isWriterInterceptor(clazz) || JaxrsUtils.isParamConverterProvider(clazz);
    }

    public static List<Class<?>> getComponents(Class<?> clazz) {
        LinkedList classes = new LinkedList();
        JaxrsUtils.getComponentsRecursively(clazz, classes, 0);
        return classes;
    }

    private static Map<Class<?>, Integer> extractContracts(Class<?> clazz, int defaultOrder) {
        if (clazz == null) {
            return Collections.emptyMap();
        }
        HashMap values = new HashMap();
        List<Class<?>> components = JaxrsUtils.getComponents(clazz);
        components.forEach(component -> values.put((Class<?>)component, defaultOrder));
        return values;
    }

    private static boolean isSetterParam(Param param, Class<? extends Annotation> target) {
        if (!param.isMethodParam()) {
            return false;
        }
        MethodParam mParam = param.methodParam();
        if (!ReflectionUtils.isSetter((Method)mParam.method())) {
            return false;
        }
        if (mParam.method().getParameterCount() != 1) {
            return false;
        }
        return AnnotationUtils.hasAnnotation((AnnotatedElement)mParam.method(), target);
    }

    private static void getComponentsRecursively(Class<?> clazz, List<Class<?>> classes, int depth) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        if (depth > 0 && JaxrsUtils.isComponent(clazz) && clazz.getName().startsWith("jakarta.ws.rs")) {
            classes.add(clazz);
        }
        ++depth;
        for (Class<?> interface0 : clazz.getInterfaces()) {
            JaxrsUtils.getComponentsRecursively(interface0, classes, depth);
        }
        JaxrsUtils.getComponentsRecursively(clazz.getSuperclass(), classes, depth);
    }

    private JaxrsUtils() {
    }

    static {
        String javaxPriorityName = "javax.annotation.Priority";
        HAS_JAVAX_PRIORITY = ClassUtils.hasClass((String)"javax.annotation.Priority");
        if (!HAS_JAVAX_PRIORITY) {
            LoggerUtils.logger().debug("No javax.annotation.Priority detected.");
        }
    }
}

