/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.util;

import esa.commons.ClassUtils;
import esa.commons.StringUtils;
import esa.commons.UrlUtils;
import esa.commons.reflect.AnnotationUtils;
import io.esastack.restlight.core.handler.method.Param;
import io.esastack.restlight.core.route.Mapping;
import io.esastack.restlight.core.route.impl.MappingImpl;
import io.esastack.restlight.core.util.ConverterUtils;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;

public final class JaxrsMappingUtils {
    private JaxrsMappingUtils() {
    }

    public static String extractDefaultValue(Param param) {
        if (param == null) {
            return null;
        }
        DefaultValue defaultValueAnn = JaxrsUtils.getAnnotation(param, DefaultValue.class);
        String defaultValue = null;
        if (defaultValueAnn != null) {
            defaultValue = defaultValueAnn.value();
        }
        return defaultValue;
    }

    public static Optional<Mapping> extractMapping(Class<?> userType, Method method, String contextPath) {
        if (method == null || userType == null) {
            return Optional.empty();
        }
        contextPath = ConverterUtils.standardContextPath((String)contextPath);
        Class<?> annotatedUserType = JaxrsMappingUtils.findAnnotatedClass(userType).orElse(userType);
        Method annotatedMethod = JaxrsMappingUtils.findAnnotatedMethod(method).orElse(method);
        String parentPath = JaxrsMappingUtils.getAnnotation(annotatedUserType, Path.class).map(Path::value).orElse(null);
        String path = JaxrsMappingUtils.getAnnotation(annotatedMethod, Path.class).map(Path::value).orElse(null);
        String[] parentConsumes = JaxrsMappingUtils.getAnnotation(annotatedUserType, Consumes.class).map(Consumes::value).orElse(null);
        String[] consumes = JaxrsMappingUtils.getAnnotation(annotatedMethod, Consumes.class).map(Consumes::value).orElse(null);
        String[] parentProduces = JaxrsMappingUtils.getAnnotation(annotatedUserType, Produces.class).map(Produces::value).orElse(null);
        String[] produces = JaxrsMappingUtils.getAnnotation(annotatedMethod, Produces.class).map(Produces::value).orElse(null);
        String parentHttpMethod = JaxrsMappingUtils.getMethod(annotatedUserType);
        String httpMethod = JaxrsMappingUtils.getMethod(annotatedMethod);
        if (path == null && httpMethod == null) {
            return Optional.empty();
        }
        if (parentPath == null && parentConsumes == null && parentProduces == null && parentHttpMethod == null) {
            return Optional.of(JaxrsMappingUtils.getMapping(contextPath, path, httpMethod, consumes, produces));
        }
        return Optional.of(JaxrsMappingUtils.getMapping(contextPath, parentPath, parentHttpMethod, parentConsumes, parentProduces).combine(JaxrsMappingUtils.getMapping(StringUtils.empty(), path, httpMethod, consumes, produces)));
    }

    public static boolean isMethod(Method element) {
        Method annotatedMethod = JaxrsMappingUtils.findAnnotatedMethod(element).orElse(element);
        return JaxrsMappingUtils.getMethod(annotatedMethod) != null;
    }

    private static String getMethod(AnnotatedElement element) {
        String method = JaxrsMappingUtils.getAnnotation(element, HttpMethod.class).map(HttpMethod::value).orElse(null);
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, GET.class).map(get -> "GET").orElse(null);
        }
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, POST.class).map(get -> "POST").orElse(null);
        }
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, PUT.class).map(get -> "PUT").orElse(null);
        }
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, DELETE.class).map(get -> "DELETE").orElse(null);
        }
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, PATCH.class).map(get -> "PATCH").orElse(null);
        }
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, OPTIONS.class).map(get -> "OPTIONS").orElse(null);
        }
        if (method == null) {
            method = JaxrsMappingUtils.getAnnotation(element, HEAD.class).map(get -> "HEAD").orElse(null);
        }
        return method;
    }

    private static Mapping getMapping(String contextPath, String path, String httpMethod, String[] consumes, String[] produces) {
        String p = ConverterUtils.standardContextPath((String)contextPath) + StringUtils.emptyIfNull((String)UrlUtils.prependLeadingSlash((String)path));
        MappingImpl mapping = Mapping.mapping((String)p).consumes(consumes == null ? new String[]{} : consumes).produces(produces == null ? new String[]{} : produces);
        if (!StringUtils.isEmpty((String)httpMethod)) {
            mapping = mapping.method(httpMethod);
        }
        return mapping;
    }

    private static <A extends Annotation> Optional<A> getAnnotation(AnnotatedElement element, Class<A> targetClass) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation((AnnotatedElement)element, targetClass));
    }

    private static Optional<Method> findAnnotatedMethod(Method method) {
        if (method == null) {
            return Optional.empty();
        }
        if (JaxrsMappingUtils.isAnnotatedElement(method)) {
            return Optional.of(method);
        }
        for (Method m : ClassUtils.findOverriddenMethods((Method)method)) {
            if (!JaxrsMappingUtils.isAnnotatedElement(m)) continue;
            return Optional.of(m);
        }
        return Optional.empty();
    }

    private static Optional<Class<?>> findAnnotatedClass(Class<?> element) {
        if (element == null || Object.class.equals(element)) {
            return Optional.empty();
        }
        if (JaxrsMappingUtils.isAnnotatedElement(element)) {
            return Optional.of(element);
        }
        for (Class<?> interface0 : element.getInterfaces()) {
            if (!JaxrsMappingUtils.isAnnotatedElement(interface0)) continue;
            return Optional.of(interface0);
        }
        return JaxrsMappingUtils.findAnnotatedClass(element.getSuperclass());
    }

    private static boolean isAnnotatedElement(AnnotatedElement element) {
        return AnnotationUtils.hasAnnotation((AnnotatedElement)element, Path.class) || AnnotationUtils.hasAnnotation((AnnotatedElement)element, HttpMethod.class) || AnnotationUtils.hasAnnotation((AnnotatedElement)element, Consumes.class) || AnnotationUtils.hasAnnotation((AnnotatedElement)element, Produces.class);
    }
}

