/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.spi.headerdelegate;

import esa.commons.StringUtils;
import io.esastack.restlight.core.util.DateUtils;
import io.esastack.restlight.jaxrs.spi.HeaderDelegateFactory;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.Date;

public class NewCookieHeaderDelegateFactory
implements HeaderDelegateFactory {
    @Override
    public RuntimeDelegate.HeaderDelegate<?> headerDelegate() {
        return new NewCookieHeaderDelegate();
    }

    static class NewCookieHeaderDelegate
    implements RuntimeDelegate.HeaderDelegate<NewCookie> {
        private static final String VERSION = "Version";
        private static final String PATH = "Path";
        private static final String DOMAIN = "Domain";
        private static final String MAX_AGE = "Max-Age";
        private static final String COMMENT = "Comment";
        private static final String SECURE = "Secure";
        private static final String EXPIRES = "Expires";
        private static final String HTTPONLY = "HttpOnly";

        NewCookieHeaderDelegate() {
        }

        public NewCookie fromString(String str) {
            String[] tokens;
            if (str == null) {
                throw new IllegalArgumentException("Failed to parse a null to NewCookie");
            }
            String name = null;
            String value = null;
            String path = null;
            String domain = null;
            String comment = null;
            int maxAge = -1;
            Date expiry = null;
            boolean secure = false;
            boolean httpOnly = false;
            for (String token : tokens = str.split(";")) {
                String trimmed = StringUtils.trim((String)token);
                if (token.startsWith(MAX_AGE)) {
                    maxAge = Integer.parseInt(trimmed.substring(MAX_AGE.length() + 1));
                    continue;
                }
                if (trimmed.startsWith(PATH)) {
                    path = trimmed.substring(PATH.length() + 1);
                    continue;
                }
                if (trimmed.startsWith(DOMAIN)) {
                    domain = trimmed.substring(DOMAIN.length() + 1);
                    continue;
                }
                if (trimmed.startsWith(COMMENT)) {
                    comment = trimmed.substring(COMMENT.length() + 1);
                    continue;
                }
                if (trimmed.startsWith(EXPIRES)) {
                    expiry = DateUtils.parse((String)trimmed.substring(EXPIRES.length() + 1));
                    continue;
                }
                if (trimmed.startsWith(SECURE)) {
                    secure = true;
                    continue;
                }
                if (trimmed.startsWith(HTTPONLY)) {
                    httpOnly = true;
                    continue;
                }
                int index = trimmed.indexOf(61);
                if (index == -1) continue;
                name = trimmed.substring(0, index);
                value = index == trimmed.length() + 1 ? "" : trimmed.substring(index + 1);
            }
            if (name == null || value == null) {
                throw new IllegalArgumentException("Failed to parse '" + str + "' to NewCookie");
            }
            return new NewCookie(name, value, path, domain, 1, comment, maxAge, expiry, secure, httpOnly);
        }

        public String toString(NewCookie value) {
            if (value == null) {
                throw new IllegalArgumentException("Failed to parse a null(NewCookie) to String");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(value.getName()).append('=').append(value.getValue());
            if (value.getDomain() != null) {
                sb.append(';').append(DOMAIN).append('=').append(value.getDomain());
            }
            if (value.getPath() != null) {
                sb.append(';').append(PATH).append('=').append(value.getPath());
            }
            if (value.getMaxAge() != -1) {
                sb.append(';').append(MAX_AGE).append('=').append(value.getMaxAge());
            }
            if (value.getExpiry() != null) {
                sb.append(';').append(EXPIRES).append('=').append(DateUtils.format((long)value.getExpiry().getTime()));
            }
            if (value.getComment() != null) {
                sb.append(';').append(COMMENT).append('=').append(value.getComment());
            }
            if (value.isSecure()) {
                sb.append(';').append(SECURE);
            }
            if (value.isHttpOnly()) {
                sb.append(';').append(HTTPONLY);
            }
            sb.append(';').append(VERSION).append('=').append(value.getVersion());
            return sb.toString();
        }
    }
}

