/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.spi.headerdelegate;

import io.esastack.commons.net.http.MediaTypeUtil;
import io.esastack.restlight.jaxrs.spi.HeaderDelegateFactory;
import io.esastack.restlight.jaxrs.util.MediaTypeUtils;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.RuntimeDelegate;

public class MediaTypeHeaderDelegateFactory
implements HeaderDelegateFactory {
    @Override
    public RuntimeDelegate.HeaderDelegate<?> headerDelegate() {
        return new MediaTypeHeaderDelegate();
    }

    private static class MediaTypeHeaderDelegate
    implements RuntimeDelegate.HeaderDelegate<MediaType> {
        private MediaTypeHeaderDelegate() {
        }

        public MediaType fromString(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Failed to parse a null to MediaType");
            }
            return MediaTypeUtils.convert(MediaTypeUtil.parseMediaType((String)value));
        }

        public String toString(MediaType value) {
            if (value == null) {
                throw new IllegalArgumentException("Failed to parse a null(MediaType) to String");
            }
            return MediaTypeUtils.convert(value).value();
        }
    }
}

