/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.spi.headerdelegate;

import esa.commons.StringUtils;
import io.esastack.restlight.core.util.HttpHeaderUtils;
import io.esastack.restlight.jaxrs.spi.HeaderDelegateFactory;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.Locale;

public class LocaleHeaderDelegateFactory
implements HeaderDelegateFactory {
    @Override
    public RuntimeDelegate.HeaderDelegate<?> headerDelegate() {
        return new LocaleHeaderDelegate();
    }

    private static class LocaleHeaderDelegate
    implements RuntimeDelegate.HeaderDelegate<Locale> {
        private LocaleHeaderDelegate() {
        }

        public Locale fromString(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Failed to parse a null to Locale");
            }
            return HttpHeaderUtils.parseToLanguage((String)value);
        }

        public String toString(Locale value) {
            if (value == null) {
                throw new IllegalArgumentException("Failed to parse a null(Locale) to String");
            }
            if (StringUtils.isEmpty((String)value.getCountry())) {
                return value.getLanguage();
            }
            return value.getLanguage() + '-' + value.getCountry();
        }
    }
}

