/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.spi.headerdelegate;

import esa.commons.StringUtils;
import io.esastack.restlight.jaxrs.impl.core.LinkImpl;
import io.esastack.restlight.jaxrs.spi.HeaderDelegateFactory;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class LinkDelegateFactory
implements HeaderDelegateFactory {
    @Override
    public RuntimeDelegate.HeaderDelegate<?> headerDelegate() {
        return new LinkDelegate();
    }

    private static class LinkDelegate
    implements RuntimeDelegate.HeaderDelegate<Link> {
        private LinkDelegate() {
        }

        public Link fromString(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Failed to parse a null to Link");
            }
            String[] tokens = StringUtils.isEmpty((String)value) ? new String[]{} : value.split(";");
            String uri = null;
            HashMap<String, String> params = new HashMap<String, String>();
            for (String token : tokens) {
                String theToken = token.trim();
                if (theToken.startsWith("<") && theToken.endsWith(">")) {
                    uri = theToken.substring(1, theToken.length() - 1);
                    continue;
                }
                int i = theToken.indexOf(61);
                if (i == -1) continue;
                String name = theToken.substring(0, i);
                String value0 = theToken.substring(i + 1).replaceAll("\"", "");
                params.put(name, value0);
            }
            return uri == null ? null : new LinkImpl(URI.create(uri), params);
        }

        public String toString(Link value) {
            String type;
            String title;
            if (value == null) {
                throw new IllegalArgumentException("Failed to parse a null(Link) to String");
            }
            StringBuilder sb = new StringBuilder("<").append(value.getUri().toString()).append(">");
            String rel = value.getRel();
            if (rel != null) {
                sb.append(";").append("rel").append("=\"").append(rel).append("\"");
            }
            if ((title = value.getTitle()) != null) {
                sb.append(";").append("title").append("=\"").append(title).append("\"");
            }
            if ((type = value.getType()) != null) {
                sb.append(";").append("type").append("=\"").append(type).append("\"");
            }
            for (Map.Entry entry : value.getParams().entrySet()) {
                String key = (String)entry.getKey();
                if ("rel".equals(key) || "title".equals(key) || "type".equals(key)) continue;
                sb.append(";").append(key).append("=\"").append((String)entry.getValue()).append("\"");
            }
            return sb.toString();
        }
    }
}

