/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.spi.headerdelegate;

import esa.commons.StringUtils;
import io.esastack.restlight.jaxrs.spi.HeaderDelegateFactory;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.ext.RuntimeDelegate;

public class EntityTagDelegateFactory
implements HeaderDelegateFactory {
    @Override
    public RuntimeDelegate.HeaderDelegate<?> headerDelegate() {
        return new EntityTagDelegate();
    }

    private static class EntityTagDelegate
    implements RuntimeDelegate.HeaderDelegate<EntityTag> {
        private EntityTagDelegate() {
        }

        public EntityTag fromString(String value) {
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            boolean weak = false;
            if (value.startsWith("W/")) {
                weak = true;
                value = value.substring(2);
            }
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            return new EntityTag(value, weak);
        }

        public String toString(EntityTag value) {
            if (value == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (value.isWeak()) {
                sb.append("W/");
            }
            sb.append('\"');
            sb.append(value.getValue());
            sb.append('\"');
            return sb.toString();
        }
    }
}

