/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.spi.headerdelegate;

import io.esastack.restlight.core.util.DateUtils;
import io.esastack.restlight.jaxrs.spi.HeaderDelegateFactory;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.Date;

public class DateDelegateFactory
implements HeaderDelegateFactory {
    @Override
    public RuntimeDelegate.HeaderDelegate<?> headerDelegate() {
        return new DateDelegate();
    }

    private static class DateDelegate
    implements RuntimeDelegate.HeaderDelegate<Date> {
        private DateDelegate() {
        }

        public Date fromString(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Failed to parse a null to Date");
            }
            return DateUtils.parseByCache((String)value);
        }

        public String toString(Date value) {
            if (value == null) {
                throw new IllegalArgumentException("Failed to parse a null(Date) to String");
            }
            return DateUtils.format((long)value.getTime());
        }
    }
}

