/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.spi;

import esa.commons.annotation.Internal;
import esa.commons.logging.Logger;
import esa.commons.logging.LoggerFactory;
import esa.commons.spi.Feature;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.core.handler.FutureTransfer;
import io.esastack.restlight.core.handler.method.HandlerMethod;
import io.esastack.restlight.core.handler.method.MethodParam;
import io.esastack.restlight.core.spi.FutureTransferFactory;
import io.esastack.restlight.core.util.Futures;
import io.esastack.restlight.jaxrs.impl.JaxrsContextUtils;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

@Feature(tags={"$internal"})
@Internal
public class AsyncResponseTransferFactory
implements FutureTransferFactory {
    public Optional<FutureTransfer> futureTransfer(HandlerMethod method) {
        for (MethodParam param : method.parameters()) {
            if (!param.hasAnnotation(Suspended.class) || !AsyncResponse.class.equals((Object)param.type())) continue;
            return Optional.of(new AsyncResponseTransfer(method));
        }
        return Optional.empty();
    }

    public int getOrder() {
        return -100;
    }

    private static class AsyncResponseTransfer
    implements FutureTransfer {
        private static final Logger logger = LoggerFactory.getLogger(AsyncResponseTransfer.class);
        private final HandlerMethod method;

        private AsyncResponseTransfer(HandlerMethod method) {
            this.method = method;
        }

        public CompletionStage<Object> transferTo(RequestContext context, Object value) {
            CompletionStage<Object> asyncResponse = JaxrsContextUtils.getAsyncResponse(context);
            if (asyncResponse == null) {
                return Futures.completedFuture((Object)value);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("The return value of method[{}] is ignored due to @Suspended AsyncResponse has taken effect.", (Object)this.method);
            }
            return asyncResponse;
        }
    }
}

