/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.resolver.param;

import esa.commons.Checks;
import io.esastack.restlight.core.DeployContext;
import io.esastack.restlight.core.handler.method.Param;
import io.esastack.restlight.core.resolver.converter.StringConverterProvider;
import io.esastack.restlight.core.resolver.factory.HandlerResolverFactory;
import io.esastack.restlight.core.resolver.param.ParamResolver;
import io.esastack.restlight.core.resolver.param.ParamResolverContext;
import io.esastack.restlight.core.resolver.param.ParamResolverFactory;
import io.esastack.restlight.core.serialize.HttpRequestSerializer;
import io.esastack.restlight.jaxrs.impl.container.ResourceContextImpl;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.List;

public class ResourceContextParamResolver
implements ParamResolverFactory {
    private final DeployContext context;

    public ResourceContextParamResolver(DeployContext context) {
        Checks.checkNotNull((Object)context, (String)"context");
        this.context = context;
    }

    public boolean supports(Param param) {
        return JaxrsUtils.hasAnnotation(param, Context.class) && ResourceContext.class.equals((Object)param.type());
    }

    public ParamResolver<ParamResolverContext> createResolver(Param param, StringConverterProvider converters, List<? extends HttpRequestSerializer> serializers, HandlerResolverFactory resolverFactory) {
        return new ResourceContextResolver(this.context);
    }

    private static class ResourceContextResolver
    implements ParamResolver<ParamResolverContext> {
        private final DeployContext context;

        private ResourceContextResolver(DeployContext context) {
            this.context = context;
        }

        public Object resolve(ParamResolverContext context) throws Exception {
            return new ResourceContextImpl(this.context.handlerFactory().orElse(null), context.requestContext());
        }
    }
}

