/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.resolver.param;

import io.esastack.restlight.core.handler.method.Param;
import io.esastack.restlight.core.resolver.converter.StringConverterProvider;
import io.esastack.restlight.core.resolver.factory.HandlerResolverFactory;
import io.esastack.restlight.core.resolver.param.ParamResolver;
import io.esastack.restlight.core.resolver.param.ParamResolverContext;
import io.esastack.restlight.core.resolver.param.ParamResolverFactory;
import io.esastack.restlight.core.serialize.HttpRequestSerializer;
import io.esastack.restlight.jaxrs.impl.JaxrsContextUtils;
import io.esastack.restlight.jaxrs.impl.container.AsyncResponseImpl;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncResponseParamResolver
implements ParamResolverFactory {
    public boolean supports(Param param) {
        return JaxrsUtils.hasAnnotation(param, Suspended.class) && param.isMethodParam() && AsyncResponse.class.equals((Object)param.type());
    }

    public ParamResolver<ParamResolverContext> createResolver(Param param, StringConverterProvider converters, List<? extends HttpRequestSerializer> serializers, HandlerResolverFactory resolverFactory) {
        return new AsyncResponseResolver();
    }

    private static class AsyncResponseResolver
    implements ParamResolver<ParamResolverContext> {
        private AsyncResponseResolver() {
        }

        public Object resolve(ParamResolverContext context) throws Exception {
            CompletableFuture<Object> asyncResponse = new CompletableFuture<Object>();
            JaxrsContextUtils.setAsyncResponse(context.requestContext(), asyncResponse);
            return new AsyncResponseImpl(asyncResponse);
        }
    }
}

