/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.ext;

import esa.commons.Checks;
import esa.commons.ClassUtils;
import io.esastack.restlight.core.context.HttpEntity;
import io.esastack.restlight.core.resolver.ResolverExecutor;
import io.esastack.restlight.core.resolver.ret.entity.ResponseEntityResolverContext;
import io.esastack.restlight.jaxrs.impl.ext.InterceptorContextImpl;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;

public class WriterInterceptorContextImpl
extends InterceptorContextImpl
implements WriterInterceptorContext {
    private final ResolverExecutor<ResponseEntityResolverContext> underlying;
    private final MultivaluedMap<String, Object> headers;
    private final WriterInterceptor[] interceptors;
    private final int interceptorsSize;
    private OutputStream outputStream;
    private int index;

    public WriterInterceptorContextImpl(ResolverExecutor<ResponseEntityResolverContext> underlying, OutputStream outputStream, MultivaluedMap<String, Object> headers, WriterInterceptor[] interceptors) {
        super(((ResponseEntityResolverContext)underlying.context()).requestContext(), (HttpEntity)((ResponseEntityResolverContext)underlying.context()).responseEntity());
        Checks.checkNotNull((Object)outputStream, (String)"outputStream");
        Checks.checkNotNull(headers, (String)"headers");
        this.underlying = underlying;
        this.outputStream = outputStream;
        this.headers = headers;
        this.interceptors = interceptors;
        this.interceptorsSize = interceptors != null ? interceptors.length : 0;
    }

    public void proceed() throws IOException, WebApplicationException {
        if (this.index >= this.interceptorsSize) {
            try {
                JaxrsUtils.convertThenAddToHeaders(this.headers, ((ResponseEntityResolverContext)this.underlying.context()).requestContext().response().headers());
                this.underlying.proceed();
                return;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new WebApplicationException((Throwable)ex);
            }
        }
        this.interceptors[this.index++].aroundWriteTo((WriterInterceptorContext)this);
    }

    public Object getEntity() {
        return ((ResponseEntityResolverContext)this.underlying.context()).requestContext().response().entity();
    }

    public void setEntity(Object entity) {
        ((ResponseEntityResolverContext)this.underlying.context()).requestContext().response().entity(entity);
        if (entity != null) {
            Class type = ClassUtils.getUserType((Object)entity);
            Class genericType = ClassUtils.getRawType((Type)type);
            this.setType(type);
            this.setGenericType(genericType);
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }
}

