/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.ext;

import esa.commons.Checks;
import esa.commons.ClassUtils;
import esa.commons.annotation.Beta;
import esa.commons.spi.SpiLoader;
import io.esastack.restlight.jaxrs.impl.core.LinkBuilderImpl;
import io.esastack.restlight.jaxrs.impl.core.ResponseBuilderImpl;
import io.esastack.restlight.jaxrs.impl.core.UriBuilderImpl;
import io.esastack.restlight.jaxrs.impl.core.VariantListBuilderImpl;
import io.esastack.restlight.jaxrs.spi.HeaderDelegateFactory;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RuntimeDelegateImpl
extends RuntimeDelegate {
    private final Map<Class<?>, RuntimeDelegate.HeaderDelegate<?>> headerDelegates;
    private final Set<Class<?>> nullHeaderDelegateClasses = new HashSet();

    public RuntimeDelegateImpl() {
        this.headerDelegates = this.loadHeaderDelegates();
    }

    public UriBuilder createUriBuilder() {
        return new UriBuilderImpl();
    }

    public Response.ResponseBuilder createResponseBuilder() {
        return new ResponseBuilderImpl();
    }

    public Variant.VariantListBuilder createVariantListBuilder() {
        return new VariantListBuilderImpl();
    }

    public <T> T createEndpoint(Application application, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        if (application == null) {
            throw new IllegalArgumentException("application must not be null");
        }
        throw new UnsupportedOperationException();
    }

    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> type) throws IllegalArgumentException {
        if (this.nullHeaderDelegateClasses.contains(type)) {
            return null;
        }
        RuntimeDelegate.HeaderDelegate<T> delegate = this.findHeaderDelegateRecursively(type);
        if (delegate == null) {
            this.nullHeaderDelegateClasses.add(type);
        }
        return delegate;
    }

    public Link.Builder createLinkBuilder() {
        return new LinkBuilderImpl();
    }

    @Beta
    public static void addHeaderDelegate(Class<?> type, RuntimeDelegate.HeaderDelegate<?> delegate) {
        Checks.checkNotNull(type, (String)"type");
        Checks.checkNotNull(delegate, (String)"delegate");
        ((RuntimeDelegateImpl)RuntimeDelegate.getInstance()).headerDelegates.put(type, delegate);
    }

    @Beta
    public static void addHeaderDelegate(RuntimeDelegate.HeaderDelegate<?> delegate) {
        RuntimeDelegateImpl.addHeaderDelegate(RuntimeDelegateImpl.getGenericType(delegate), delegate);
    }

    @Beta
    public static void addHeaderDelegateFactory(HeaderDelegateFactory factory) {
        Checks.checkNotNull((Object)factory, (String)"factory");
        RuntimeDelegate.HeaderDelegate<?> delegate = factory.headerDelegate();
        if (delegate != null) {
            RuntimeDelegateImpl.addHeaderDelegate(delegate);
        }
    }

    private <T> RuntimeDelegate.HeaderDelegate<T> findHeaderDelegateRecursively(Class<T> type) {
        if (Object.class.equals(type)) {
            return null;
        }
        RuntimeDelegate.HeaderDelegate<?> delegate = this.headerDelegates.get(type);
        if (delegate != null) {
            return delegate;
        }
        for (Class<?> clazz : type.getInterfaces()) {
            delegate = this.findHeaderDelegateRecursively(clazz);
            if (delegate == null) continue;
            return delegate;
        }
        Class<T> supClass = type.getSuperclass();
        if (supClass != null) {
            return this.findHeaderDelegateRecursively(supClass);
        }
        return null;
    }

    private Map<Class<?>, RuntimeDelegate.HeaderDelegate<?>> loadHeaderDelegates() {
        LinkedHashMap delegates = new LinkedHashMap();
        SpiLoader.cached(HeaderDelegateFactory.class).getAll().stream().map(HeaderDelegateFactory::headerDelegate).collect(Collectors.toList()).forEach(delegate -> delegates.put(RuntimeDelegateImpl.getGenericType(delegate), (RuntimeDelegate.HeaderDelegate<?>)delegate));
        return delegates;
    }

    private static Class<?> getGenericType(RuntimeDelegate.HeaderDelegate<?> delegate) {
        return ClassUtils.findFirstGenericType((Class)ClassUtils.getUserType(delegate)).orElse(Object.class);
    }
}

