/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.ext;

import esa.commons.Checks;
import esa.commons.ClassUtils;
import esa.commons.logging.Logger;
import esa.commons.logging.LoggerFactory;
import esa.commons.reflect.AnnotationUtils;
import io.esastack.restlight.core.resolver.exception.DefaultExceptionMapper;
import io.esastack.restlight.core.resolver.exception.ExceptionResolver;
import io.esastack.restlight.core.util.Ordered;
import io.esastack.restlight.core.util.OrderedComparator;
import io.esastack.restlight.jaxrs.adapter.JaxrsExceptionMapperAdapter;
import io.esastack.restlight.jaxrs.configure.ProvidersFactory;
import io.esastack.restlight.jaxrs.configure.ProxyComponent;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ProvidersImpl
implements Providers {
    private static final Logger logger = LoggerFactory.getLogger(ProvidersImpl.class);
    private final ProvidersFactory providers;
    private final AtomicReference<ConsumesComponent<MessageBodyReader<?>>[]> messageBodyReaders = new AtomicReference();
    private final AtomicReference<ProducesComponent<MessageBodyWriter<?>>[]> messageBodyWriters = new AtomicReference();
    private final AtomicReference<io.esastack.restlight.core.resolver.exception.ExceptionMapper> exceptionMappers = new AtomicReference();
    private final AtomicReference<ProducesComponent<ContextResolver<?>>[]> contextResolvers = new AtomicReference();

    public ProvidersImpl(ProvidersFactory providers) {
        Checks.checkNotNull((Object)providers, (String)"providers");
        this.providers = providers;
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Object[] readers = this.messageBodyReaders.updateAndGet(pre -> {
            if (pre != null) {
                return pre;
            }
            Collection<ProxyComponent<MessageBodyReader<?>>> readers0 = this.providers.messageBodyReaders();
            ConsumesComponent[] current = new ConsumesComponent[readers0.size()];
            int i = 0;
            for (ProxyComponent<MessageBodyReader<?>> reader : readers0) {
                current[i++] = new ConsumesComponent(reader.proxied(), ClassUtils.findFirstGenericType(reader.underlying().getClass()).orElse(Object.class), JaxrsUtils.getOrder(reader.underlying()), ProvidersImpl.consumes(reader.underlying()).toArray(new MediaType[0]));
            }
            return current;
        });
        if (readers.length == 0) {
            return null;
        }
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        OrderedComparator.sort((Object[])readers);
        LinkedList<Object> filtered = new LinkedList<Object>();
        for (Object reader : readers) {
            if (!((ConsumesComponent)reader).type.isAssignableFrom(type) || !this.isCompatible(mediaType, ((ConsumesComponent)reader).consumes) || !((MessageBodyReader)((ConsumesComponent)reader).underlying).isReadable(type, genericType, annotations, mediaType)) continue;
            filtered.add(((ConsumesComponent)reader).underlying);
        }
        if (filtered.isEmpty()) {
            return null;
        }
        return (MessageBodyReader)filtered.get(0);
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Object[] writers = this.messageBodyWriters.updateAndGet(pre -> {
            if (pre != null) {
                return pre;
            }
            Collection<ProxyComponent<MessageBodyWriter<?>>> writers0 = this.providers.messageBodyWriters();
            ProducesComponent[] current = new ProducesComponent[writers0.size()];
            int i = 0;
            for (ProxyComponent<MessageBodyWriter<?>> reader : writers0) {
                current[i++] = new ProducesComponent(reader.proxied(), ClassUtils.findFirstGenericType(reader.underlying().getClass()).orElse(Object.class), JaxrsUtils.getOrder(reader.underlying()), ProvidersImpl.produces(reader.underlying()).toArray(new MediaType[0]));
            }
            return current;
        });
        if (writers.length == 0) {
            return null;
        }
        OrderedComparator.sort((Object[])writers);
        LinkedList<Object> filtered = new LinkedList<Object>();
        for (Object writer : writers) {
            if (!((ProducesComponent)writer).type.isAssignableFrom(type) || !this.isCompatible(mediaType, ((ProducesComponent)writer).produces) || !((MessageBodyWriter)((ProducesComponent)writer).underlying).isWriteable(type, genericType, annotations, mediaType)) continue;
            filtered.add(((ProducesComponent)writer).underlying);
        }
        if (filtered.isEmpty()) {
            return null;
        }
        return (MessageBodyWriter)filtered.get(0);
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        io.esastack.restlight.core.resolver.exception.ExceptionMapper mapper = this.exceptionMappers.updateAndGet(pre -> {
            if (pre != null) {
                return pre;
            }
            HashMap mappings = new HashMap();
            for (ProxyComponent proxyComponent : this.providers.exceptionMappers()) {
                Class<Throwable> matchedType = ClassUtils.findFirstGenericType((Class)ClassUtils.getUserType((Object)proxyComponent.underlying())).orElse(Throwable.class);
                JaxrsExceptionMapperAdapter previous = mappings.put(matchedType, new JaxrsExceptionMapperAdapter(proxyComponent));
                if (previous == null) continue;
                logger.warn("Found ambiguous ExceptionMapper to handle {}, the previous {} is ignored.", mappings, (Object)ClassUtils.getUserType((Object)previous.underlying().underlying()));
            }
            if (mappings.isEmpty()) {
                return type1 -> null;
            }
            return new DefaultExceptionMapper(mappings);
        });
        ExceptionResolver mapped = mapper.mapTo(type);
        if (mapped == null) {
            return null;
        }
        return ((JaxrsExceptionMapperAdapter)mapped).underlying().proxied();
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        Object[] resolvers = this.contextResolvers.updateAndGet(pre -> {
            if (pre != null) {
                return pre;
            }
            Collection<ProxyComponent<ContextResolver<?>>> resolvers0 = this.providers.contextResolvers();
            ProducesComponent[] current = new ProducesComponent[resolvers0.size()];
            int i = 0;
            for (ProxyComponent<ContextResolver<?>> resolver : resolvers0) {
                current[i++] = new ProducesComponent(resolver.proxied(), ClassUtils.findFirstGenericType(resolver.underlying().getClass()).orElse(Object.class), JaxrsUtils.getOrder(resolver.underlying()), ProvidersImpl.produces(resolver.underlying()).toArray(new MediaType[0]));
            }
            return current;
        });
        if (resolvers.length == 0) {
            return null;
        }
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        OrderedComparator.sort((Object[])resolvers);
        LinkedList<Object> filtered = new LinkedList<Object>();
        for (Object resolver : resolvers) {
            if (!((ProducesComponent)resolver).type.isAssignableFrom(contextType) || !this.isCompatible(mediaType, ((ProducesComponent)resolver).produces)) continue;
            filtered.add(((ProducesComponent)resolver).underlying);
        }
        if (filtered.isEmpty()) {
            return null;
        }
        return (ContextResolver)filtered.get(0);
    }

    static List<MediaType> consumes(Object obj) {
        Consumes consumes = (Consumes)AnnotationUtils.findAnnotation((AnnotatedElement)ClassUtils.getUserType((Object)obj), Consumes.class);
        return ProvidersImpl.convertToMediaTypes(consumes == null ? new String[]{} : consumes.value());
    }

    static List<MediaType> produces(Object obj) {
        Produces produces = (Produces)AnnotationUtils.findAnnotation((AnnotatedElement)ClassUtils.getUserType((Object)obj), Produces.class);
        return ProvidersImpl.convertToMediaTypes(produces == null ? new String[]{} : produces.value());
    }

    private static List<MediaType> convertToMediaTypes(String[] values) {
        if (values == null || values.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(values.length);
        for (String value : values) {
            mediaTypes.add(MediaType.valueOf((String)value));
        }
        return mediaTypes;
    }

    private boolean isCompatible(MediaType current, MediaType[] target) {
        if (target.length == 0) {
            return true;
        }
        for (MediaType type : target) {
            if (!type.isCompatible(current)) continue;
            return true;
        }
        return false;
    }

    private static class ConsumesComponent<T>
    extends GenericComponent<T> {
        private final MediaType[] consumes;

        private ConsumesComponent(T underlying, Class<?> type, int order, MediaType[] consumes) {
            super(underlying, type, order);
            this.consumes = consumes;
        }
    }

    private static class ProducesComponent<T>
    extends GenericComponent<T> {
        private final MediaType[] produces;

        private ProducesComponent(T underlying, Class<?> type, int order, MediaType[] produces) {
            super(underlying, type, order);
            this.produces = produces;
        }
    }

    private static class GenericComponent<T>
    implements Ordered {
        final T underlying;
        final Class<?> type;
        private final int order;

        private GenericComponent(T underlying, Class<?> type, int order) {
            this.underlying = underlying;
            this.type = type;
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

