/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.ext;

import esa.commons.Checks;
import esa.commons.collection.AttributeKey;
import io.esastack.restlight.core.context.HttpEntity;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.jaxrs.util.MediaTypeUtils;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.InterceptorContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;

class InterceptorContextImpl
implements InterceptorContext {
    private final RequestContext requestContext;
    private final HttpEntity httpEntity;

    InterceptorContextImpl(RequestContext requestContext, HttpEntity httpEntity) {
        Checks.checkNotNull((Object)requestContext, (String)"requestContext");
        Checks.checkNotNull((Object)httpEntity, (String)"httpEntity");
        this.requestContext = requestContext;
        this.httpEntity = httpEntity;
    }

    public Object getProperty(String name) {
        return this.requestContext.attrs().attr(AttributeKey.valueOf((String)name)).get();
    }

    public Collection<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>(this.requestContext.attrs().size());
        this.requestContext.attrs().forEach((name, value) -> names.add(name.name()));
        return names;
    }

    public void setProperty(String name, Object object) {
        this.requestContext.attrs().attr(AttributeKey.valueOf((String)name)).set(object);
    }

    public void removeProperty(String name) {
        this.requestContext.attrs().attr(AttributeKey.valueOf((String)name)).remove();
    }

    public Annotation[] getAnnotations() {
        return this.httpEntity.annotations();
    }

    public void setAnnotations(Annotation[] annotations) {
        this.httpEntity.annotations(annotations);
    }

    public Class<?> getType() {
        return this.httpEntity.type();
    }

    public void setType(Class<?> type) {
        this.httpEntity.type(type);
    }

    public Type getGenericType() {
        return this.httpEntity.genericType();
    }

    public void setGenericType(Type genericType) {
        this.httpEntity.genericType(genericType);
    }

    public MediaType getMediaType() {
        return MediaTypeUtils.convert(this.httpEntity.mediaType());
    }

    public void setMediaType(MediaType mediaType) {
        this.httpEntity.mediaType(MediaTypeUtils.convert(mediaType));
    }
}

