/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Variant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class VariantListBuilderImpl
extends Variant.VariantListBuilder {
    private final List<Variant> variants = new LinkedList<Variant>();
    private final List<Locale> languages = new LinkedList<Locale>();
    private final List<String> encodings = new LinkedList<String>();
    private final List<MediaType> mediaTypes = new LinkedList<MediaType>();

    public List<Variant> build() {
        this.add();
        return new ArrayList<Variant>(this.variants);
    }

    public Variant.VariantListBuilder add() {
        if (this.languages.isEmpty() && this.encodings.isEmpty() && this.mediaTypes.isEmpty()) {
            return this;
        }
        for (Locale language : this.languages) {
            for (String encoding : this.encodings) {
                for (MediaType mediaType : this.mediaTypes) {
                    this.variants.add(new Variant(mediaType, language, encoding));
                }
            }
        }
        this.reset();
        return this;
    }

    public Variant.VariantListBuilder languages(Locale ... languages) {
        if (languages == null || languages.length == 0) {
            return this;
        }
        this.languages.addAll(Arrays.asList(languages));
        return this;
    }

    public Variant.VariantListBuilder encodings(String ... encodings) {
        if (encodings == null || encodings.length == 0) {
            return this;
        }
        this.encodings.addAll(Arrays.asList(encodings));
        return this;
    }

    public Variant.VariantListBuilder mediaTypes(MediaType ... mediaTypes) {
        if (mediaTypes == null || mediaTypes.length == 0) {
            return this;
        }
        this.mediaTypes.addAll(Arrays.asList(mediaTypes));
        return this;
    }

    private void reset() {
        this.languages.clear();
        this.encodings.clear();
        this.mediaTypes.clear();
    }
}

