/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import esa.commons.Checks;
import esa.commons.StringUtils;
import esa.commons.logging.Logger;
import esa.commons.logging.LoggerFactory;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.core.handler.HandlerMapping;
import io.esastack.restlight.core.spi.impl.RouteTracking;
import io.esastack.restlight.core.util.PathVariableUtils;
import io.esastack.restlight.jaxrs.impl.core.MatchedResource;
import io.esastack.restlight.jaxrs.impl.core.PathSegmentImpl;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UriInfoImpl
implements UriInfo {
    private static final Logger logger = LoggerFactory.getLogger(UriInfoImpl.class);
    private final RequestContext context;
    private URI baseUri;

    public UriInfoImpl(URI baseUri, RequestContext context) {
        Checks.checkNotNull((Object)baseUri, (String)"baseUri");
        Checks.checkNotNull((Object)context, (String)"context");
        this.baseUri = baseUri;
        this.context = context;
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        return this.context.request().path();
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        String path = this.getPath(decode);
        if (path.isEmpty()) {
            return Collections.emptyList();
        }
        String[] subPaths = path.split("/");
        LinkedList<PathSegmentImpl> segments = new LinkedList<PathSegmentImpl>();
        for (String subPath : subPaths) {
            if (!StringUtils.isNotEmpty((String)subPath)) continue;
            segments.add(new PathSegmentImpl(subPath));
        }
        return Collections.unmodifiableList(segments);
    }

    public URI getRequestUri() {
        return URI.create(this.context.request().uri());
    }

    public UriBuilder getRequestUriBuilder() {
        return RuntimeDelegate.getInstance().createUriBuilder().uri(this.getRequestUri());
    }

    public URI getAbsolutePath() {
        return this.getBaseUri().resolve(this.getPath(false));
    }

    public UriBuilder getAbsolutePathBuilder() {
        return RuntimeDelegate.getInstance().createUriBuilder().uri(this.getAbsolutePath());
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public UriBuilder getBaseUriBuilder() {
        return RuntimeDelegate.getInstance().createUriBuilder().uri(this.getBaseUri());
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        Map variables = PathVariableUtils.getPathVariables((RequestContext)this.context);
        if (variables == null || variables.isEmpty()) {
            return new MultivaluedHashMap();
        }
        MultivaluedHashMap params = new MultivaluedHashMap();
        for (Map.Entry entry : variables.entrySet()) {
            params.add(entry.getKey(), (Object)(decode ? UriInfoImpl.decode((String)entry.getValue()) : (String)entry.getValue()));
        }
        return params;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        MultivaluedHashMap parameters = new MultivaluedHashMap();
        if (StringUtils.isEmpty((String)this.context.request().query())) {
            return parameters;
        }
        for (String item : this.context.request().query().split("&")) {
            if (StringUtils.isEmpty((String)item)) continue;
            String[] pairs = item.split("=");
            if (pairs.length != 2) {
                throw new IllegalStateException("Failed to split query pair from [" + item + "]");
            }
            parameters.add((Object)pairs[0], (Object)pairs[1]);
        }
        return parameters;
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public List<String> getMatchedURIs(boolean decode) {
        List mappings = RouteTracking.tracking((RequestContext)this.context);
        if (mappings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> uris = new ArrayList<String>(mappings.size());
        for (HandlerMapping mapping : mappings) {
            uris.add(mapping.mapping().toString());
        }
        Collections.reverse(uris);
        return Collections.unmodifiableList(uris);
    }

    public List<Object> getMatchedResources() {
        List mappings = RouteTracking.tracking((RequestContext)this.context);
        if (mappings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MatchedResource> resources = new ArrayList<MatchedResource>(mappings.size());
        for (HandlerMapping mapping : mappings) {
            resources.add(new MatchedResource(mapping.methodInfo(), mapping.bean().orElse(null)));
        }
        Collections.reverse(resources);
        return Collections.unmodifiableList(resources);
    }

    public URI resolve(URI uri) {
        if (uri.isAbsolute()) {
            return uri;
        }
        return this.getBaseUri().resolve(uri);
    }

    public URI relativize(URI uri) {
        return UriInfoImpl.relativize(this.getRequestUri(), this.resolve(uri));
    }

    public void baseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    private static String decode(String value) {
        try {
            value = URLDecoder.decode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            logger.warn("Failed to decode {} by UTF-8", (Object)value);
        }
        return value;
    }

    static URI relativize(URI base, URI uri) {
        if (!base.isAbsolute() || !uri.isAbsolute()) {
            return uri;
        }
        if (base.isOpaque() || uri.isOpaque()) {
            return uri;
        }
        URI root = base.resolve("/");
        if (!root.equals(uri.resolve("/"))) {
            return uri;
        }
        URI baseRel = URI.create("/").resolve(root.relativize(base));
        URI uriRel = URI.create("/").resolve(root.relativize(uri));
        if (baseRel.getPath().equals(uriRel.getPath())) {
            return baseRel.relativize(uriRel);
        }
        URI commonBase = baseRel.resolve("./");
        if (commonBase.equals(uriRel.resolve("./"))) {
            return commonBase.relativize(uriRel);
        }
        URI relative = URI.create("");
        while (!uriRel.getPath().startsWith(commonBase.getPath()) && !commonBase.getPath().equals("/")) {
            commonBase = commonBase.resolve("../");
            relative = relative.resolve("../");
        }
        URI relToCommon = commonBase.relativize(uriRel);
        return relative.resolve(relToCommon);
    }
}

