/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import esa.commons.Checks;
import esa.commons.ClassUtils;
import esa.commons.StringUtils;
import esa.commons.reflect.AnnotationUtils;
import io.esastack.restlight.jaxrs.util.UriUtils;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class UriBuilderImpl
extends UriBuilder {
    private static final Predicate<Method> annotatedWithPath = method -> AnnotationUtils.hasAnnotation((AnnotatedElement)method, Path.class);
    private String scheme;
    private String userInfo;
    private String host;
    private int port;
    private String path;
    private String query;
    private String fragment;

    public UriBuilderImpl() {
    }

    private UriBuilderImpl(String scheme, String userInfo, String host, int port, String path, String query, String fragment) {
        this.scheme = scheme;
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
    }

    public UriBuilder clone() {
        return new UriBuilderImpl(this.scheme, this.userInfo, this.host, this.port, this.path, this.query, this.fragment);
    }

    public UriBuilder uri(URI uri) {
        Checks.checkArg((uri != null ? 1 : 0) != 0, (String)"uri must not be null");
        if (uri.getScheme() != null) {
            this.scheme = uri.getScheme();
        }
        if (uri.getRawUserInfo() != null) {
            this.userInfo = uri.getRawUserInfo();
        }
        if (uri.getHost() != null) {
            this.host = uri.getHost();
        }
        if (uri.getPort() > 0) {
            this.port = uri.getPort();
        }
        if (uri.getRawPath() != null) {
            this.path = uri.getRawPath();
        }
        if (uri.getRawQuery() != null) {
            this.query = uri.getRawQuery();
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        return this;
    }

    public UriBuilder uri(String uriTemplate) {
        Checks.checkArg((uriTemplate != null ? 1 : 0) != 0, (String)"uriTemplate must not be null");
        try {
            return this.uri(new URI(uriTemplate));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Error occurred when parsing:[" + uriTemplate + "] to URI", ex);
        }
    }

    public UriBuilder scheme(String scheme) {
        if (scheme == null) {
            scheme = "http";
        }
        if ("http".equals(scheme) || "https".equals(scheme)) {
            this.scheme = scheme;
            return this;
        }
        throw new IllegalArgumentException("illegal scheme: " + scheme);
    }

    public UriBuilder schemeSpecificPart(String ssp) {
        Checks.checkArg((ssp != null ? 1 : 0) != 0, (String)"ssp must not be null");
        if (this.scheme == null) {
            this.scheme = "http";
        }
        StringBuilder sb = new StringBuilder(this.scheme);
        if (!ssp.startsWith("://")) {
            sb.append("://");
        }
        sb.append(ssp);
        if (StringUtils.isNotEmpty((String)this.fragment)) {
            sb.append("#").append(this.fragment);
        }
        return this.uri(URI.create(sb.toString()));
    }

    public UriBuilder userInfo(String ui) {
        this.userInfo = ui;
        return this;
    }

    public UriBuilder host(String host) {
        Checks.checkNotEmptyArg((String)host, (String)"host must be null or empty");
        this.host = host;
        return this;
    }

    public UriBuilder port(int port) {
        Checks.checkArg((port > 0 && port <= 65535 ? 1 : 0) != 0, (String)("illegal port: " + port));
        this.port = port;
        return this;
    }

    public UriBuilder replacePath(String path) {
        if (path != null && !path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
        return this;
    }

    public UriBuilder path(String path) {
        Checks.checkArg((path != null ? 1 : 0) != 0, (String)"path must not be null");
        this.path = StringUtils.isEmpty((String)this.path) ? path : (this.path.endsWith("/") ? (path.startsWith("/") ? this.path + path.substring(1) : this.path + path) : (path.startsWith("/") ? this.path + path : this.path + "/" + path));
        return this;
    }

    public UriBuilder path(Class resource) {
        Checks.checkArg((resource != null ? 1 : 0) != 0, (String)"resource must not be null");
        Path path = (Path)AnnotationUtils.findAnnotation((AnnotatedElement)resource, Path.class);
        if (path == null) {
            throw new IllegalArgumentException("@Path must be annotated on class: " + resource.getSimpleName());
        }
        return this.path(path.value());
    }

    public UriBuilder path(Class resource, String method) {
        Checks.checkArg((resource != null ? 1 : 0) != 0, (String)"resource must not be null");
        Checks.checkNotEmptyArg((String)method, (String)"method must not be null or empty");
        List<Method> methods = UriBuilderImpl.selectMethods(resource, method);
        if (methods.size() != 1) {
            throw new IllegalArgumentException("Found " + methods.size() + " methods which" + " named:[" + method + "] and annotated with @Path");
        }
        return this.path(methods.get(0));
    }

    public UriBuilder path(Method method) {
        Checks.checkArg((method != null ? 1 : 0) != 0, (String)"method must not be null");
        Path path = (Path)AnnotationUtils.findAnnotation((AnnotatedElement)method, Path.class);
        if (path == null) {
            throw new IllegalArgumentException("@Path must be annotated on method: " + method.getName());
        }
        return this.path(path.value());
    }

    public UriBuilder segment(String ... segments) {
        Checks.checkArg((segments != null ? 1 : 0) != 0, (String)"segments must not be null");
        for (String segment : segments) {
            Checks.checkArg((segment != null ? 1 : 0) != 0, (String)"segment item must not be null");
        }
        for (String segment : segments) {
            if (StringUtils.isEmpty((String)segment)) continue;
            this.path(UriUtils.encode(segment));
        }
        return this;
    }

    public UriBuilder replaceMatrix(String matrix) {
        int start;
        int matrixIndex;
        if (StringUtils.isNotEmpty((String)(matrix = UriBuilderImpl.checkNotNull(matrix))) && !matrix.startsWith(";")) {
            matrix = ";" + matrix;
        }
        matrix = UriUtils.encode(matrix);
        this.path = StringUtils.isEmpty((String)this.path) ? matrix : ((matrixIndex = this.path.indexOf(";", start = Math.max(0, this.path.lastIndexOf("/")))) > -1 ? this.path.substring(0, matrixIndex) + matrix : this.path + matrix);
        return this;
    }

    public UriBuilder matrixParam(String name, Object ... values) {
        Checks.checkArg((name != null ? 1 : 0) != 0, (String)"name must not be null");
        Checks.checkArg((values != null ? 1 : 0) != 0, (String)"values must not be null");
        StringBuilder path = new StringBuilder(UriBuilderImpl.checkNotNull(this.path));
        for (Object value : values) {
            if (value == null) continue;
            path.append(";").append(UriUtils.encode(name)).append("=").append(UriUtils.encode(value.toString()));
        }
        this.path = path.toString();
        return this;
    }

    public UriBuilder replaceMatrixParam(String name, Object ... values) {
        Checks.checkArg((name != null ? 1 : 0) != 0, (String)"name must not be null");
        this.replaceMatrix(null);
        if (values != null) {
            this.matrixParam(name, values);
        }
        return this;
    }

    public UriBuilder replaceQuery(String query) {
        this.query = StringUtils.isEmpty((String)query) ? null : UriUtils.encode(query);
        return this;
    }

    public UriBuilder queryParam(String name, Object ... values) {
        Checks.checkArg((name != null ? 1 : 0) != 0, (String)"name must not be null");
        Checks.checkArg((values != null ? 1 : 0) != 0, (String)"values must not be null");
        StringBuilder sb = new StringBuilder(UriBuilderImpl.checkNotNull(this.query));
        String prefix = StringUtils.isEmpty((String)this.query) ? "" : "&";
        for (Object value : values) {
            sb.append(prefix).append(UriUtils.encode(name)).append("=").append(UriUtils.encode(value.toString()));
            prefix = "&";
        }
        this.query = sb.toString();
        return this;
    }

    public UriBuilder replaceQueryParam(String name, Object ... values) {
        Checks.checkArg((name != null ? 1 : 0) != 0, (String)"name must not be null");
        if (values == null || values.length == 0) {
            this.query = null;
        } else {
            StringBuilder sb = new StringBuilder();
            String prefix = "";
            for (Object value : values) {
                if (value == null) continue;
                sb.append(prefix).append(UriUtils.encode(name)).append("=").append(UriUtils.encode(value.toString()));
                prefix = "&";
            }
            this.query = sb.toString();
        }
        return this;
    }

    public UriBuilder fragment(String fragment) {
        this.fragment = StringUtils.isEmpty((String)fragment) ? null : UriUtils.encode(fragment);
        return this;
    }

    public UriBuilder resolveTemplate(String name, Object value) {
        Checks.checkArg((name != null ? 1 : 0) != 0, (String)"name must not be null");
        Checks.checkArg((value != null ? 1 : 0) != 0, (String)"value must not be null");
        return this.resolveTemplates(Collections.singletonMap(name, value), true, false, false);
    }

    public UriBuilder resolveTemplate(String name, Object value, boolean encodeSlashInPath) {
        Checks.checkArg((name != null ? 1 : 0) != 0, (String)"name must not be null");
        Checks.checkArg((value != null ? 1 : 0) != 0, (String)"value must not be null");
        return this.resolveTemplates(Collections.singletonMap(name, value), encodeSlashInPath, false, false);
    }

    public UriBuilder resolveTemplateFromEncoded(String name, Object value) {
        Checks.checkArg((name != null ? 1 : 0) != 0, (String)"name must not be null");
        Checks.checkArg((value != null ? 1 : 0) != 0, (String)"value must not be null");
        return this.resolveTemplates(Collections.singletonMap(name, value), true, false, true);
    }

    public UriBuilder resolveTemplates(Map<String, Object> templateValues) {
        UriBuilderImpl.checkTemplateMaps(templateValues);
        return this.resolveTemplates(templateValues, true, false, false);
    }

    public UriBuilder resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) throws IllegalArgumentException {
        UriBuilderImpl.checkTemplateMaps(templateValues);
        return this.resolveTemplates(templateValues, encodeSlashInPath, false, false);
    }

    public UriBuilder resolveTemplatesFromEncoded(Map<String, Object> templateValues) {
        UriBuilderImpl.checkTemplateMaps(templateValues);
        return this.resolveTemplates(templateValues, true, false, true);
    }

    public URI buildFromMap(Map<String, ?> values) {
        UriBuilderImpl.checkEntryValues(values);
        this.resolveTemplates(values, true, true, false);
        return this.doBuild();
    }

    public URI buildFromMap(Map<String, ?> values, boolean encodeSlashInPath) throws IllegalArgumentException, UriBuilderException {
        UriBuilderImpl.checkEntryValues(values);
        this.resolveTemplates(values, encodeSlashInPath, true, false);
        return this.doBuild();
    }

    public URI buildFromEncodedMap(Map<String, ?> values) throws IllegalArgumentException, UriBuilderException {
        UriBuilderImpl.checkEntryValues(values);
        this.resolveTemplates(values, true, false, true);
        return this.doBuild();
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        UriBuilderImpl.checkValues(values);
        this.resolveTemplates(values, true, true, false);
        return this.doBuild();
    }

    public URI build(Object[] values, boolean encodeSlashInPath) throws IllegalArgumentException, UriBuilderException {
        UriBuilderImpl.checkValues(values);
        this.resolveTemplates(values, encodeSlashInPath, true, false);
        return this.doBuild();
    }

    public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
        UriBuilderImpl.checkValues(values);
        this.resolveTemplates(values, true, false, true);
        return this.doBuild();
    }

    public String toTemplate() {
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append("://");
        }
        if (this.userInfo != null) {
            sb.append(this.userInfo).append("@");
        }
        if (StringUtils.isEmpty((String)this.host)) {
            if (sb.length() > 0) {
                throw new UriBuilderException("host must not be absent");
            }
        } else {
            sb.append(this.host);
        }
        if (this.port > 0) {
            sb.append(":").append(this.port);
        }
        if (StringUtils.isNotEmpty((String)this.path)) {
            if (!this.path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(this.path);
        }
        if (this.query != null) {
            sb.append("?").append(this.query);
        }
        if (this.fragment != null) {
            sb.append("#").append(this.fragment);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UriBuilderImpl{");
        sb.append("scheme='").append(this.scheme).append('\'');
        sb.append(", userInfo='").append(this.userInfo).append('\'');
        sb.append(", host='").append(this.host).append('\'');
        sb.append(", port=").append(this.port);
        sb.append(", path='").append(this.path).append('\'');
        sb.append(", query='").append(this.query).append('\'');
        sb.append(", fragment='").append(this.fragment).append('\'');
        sb.append('}');
        return sb.toString();
    }

    private URI doBuild() {
        String uri = null;
        try {
            uri = this.toTemplate();
            return new URI(uri);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException("Failed to convert :[" + uri + "] to URI", (Throwable)ex);
        }
    }

    private UriBuilder resolveTemplates(Map<String, ?> templateValues, boolean encodeSlashInPath, boolean encodePercentAnyway, boolean encodePercentCondition) {
        if (templateValues == null || templateValues.isEmpty()) {
            return this;
        }
        this.userInfo = UriBuilderImpl.doResolveTemplate((template, index) -> templateValues.get(template), this.userInfo, false, encodePercentAnyway, encodePercentCondition);
        this.host = UriBuilderImpl.doResolveTemplate((template, index) -> templateValues.get(template), this.host, false, encodePercentAnyway, encodePercentCondition);
        this.path = UriBuilderImpl.doResolveTemplate((template, index) -> templateValues.get(template), this.path, encodeSlashInPath, encodePercentAnyway, encodePercentCondition);
        this.query = UriBuilderImpl.doResolveTemplate((template, index) -> templateValues.get(template), this.query, false, encodePercentAnyway, encodePercentCondition);
        this.fragment = UriBuilderImpl.doResolveTemplate((template, index) -> templateValues.get(template), this.fragment, false, encodePercentAnyway, encodePercentCondition);
        return this;
    }

    private void resolveTemplates(Object[] values, boolean encodeSlashInPath, boolean encodePercentAnyway, boolean encodePercentCondition) {
        if (values == null || values.length == 0) {
            return;
        }
        HashMap templateValues = new HashMap();
        BiFunction<String, Integer, Object> valueFunction = (template, index) -> {
            Object value = templateValues.get(template);
            if (value != null) {
                return value;
            }
            value = values[index];
            templateValues.put(template, value.toString());
            return templateValues.get(template);
        };
        this.userInfo = UriBuilderImpl.doResolveTemplate(valueFunction, this.userInfo, false, encodePercentAnyway, encodePercentCondition);
        this.host = UriBuilderImpl.doResolveTemplate(valueFunction, this.host, false, encodePercentAnyway, encodePercentCondition);
        this.path = UriBuilderImpl.doResolveTemplate(valueFunction, this.path, encodeSlashInPath, encodePercentAnyway, encodePercentCondition);
        this.query = UriBuilderImpl.doResolveTemplate(valueFunction, this.query, false, encodePercentAnyway, encodePercentCondition);
        this.fragment = UriBuilderImpl.doResolveTemplate(valueFunction, this.fragment, false, encodePercentAnyway, encodePercentCondition);
    }

    private static String doResolveTemplate(BiFunction<String, Integer, ?> valueFunction, String target, boolean encodeSlashInPath, boolean encodePercentAnyway, boolean encodePercentCondition) {
        if (StringUtils.isEmpty((String)target)) {
            return target;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        block0: for (int i = 0; i < target.length(); ++i) {
            if (target.charAt(i) == '{') {
                for (int j = i; j < target.length(); ++j) {
                    if (target.charAt(j) != '}') continue;
                    String template = target.substring(i + 1, j);
                    Object value = valueFunction.apply(template, index);
                    if (value == null) {
                        sb.append(target, i, Math.min(target.length(), j + 1));
                    } else {
                        sb.append(UriUtils.encode(value.toString(), encodeSlashInPath, encodePercentAnyway, encodePercentCondition));
                    }
                    i = j;
                    ++index;
                    continue block0;
                }
                continue;
            }
            sb.append(target.charAt(i));
        }
        return sb.toString();
    }

    private static void checkTemplateMaps(Map<String, ?> templateValues) {
        Checks.checkArg((templateValues != null ? 1 : 0) != 0, (String)"templateValues must not be null");
        for (Map.Entry<String, ?> item : templateValues.entrySet()) {
            Checks.checkArg((item.getKey() != null ? 1 : 0) != 0, (String)"null key in templateValues is illegal");
            Checks.checkArg((item.getValue() != null ? 1 : 0) != 0, (String)"null value in templateValues is illegal");
        }
    }

    private static void checkEntryValues(Map<String, ?> values) {
        if (values == null) {
            return;
        }
        for (Map.Entry<String, ?> item : values.entrySet()) {
            Checks.checkArg((item.getValue() != null ? 1 : 0) != 0, (String)"null value in values is illegal");
        }
    }

    private static void checkValues(Object ... values) {
        if (values == null) {
            return;
        }
        for (Object item : values) {
            Checks.checkArg((item != null ? 1 : 0) != 0, (String)"null value in values is illegal");
        }
    }

    private static String checkNotNull(String value) {
        return value == null ? "" : value;
    }

    private static List<Method> selectMethods(Class<?> resource, String method) {
        LinkedList<Method> methods = new LinkedList<Method>();
        ClassUtils.doWithUserDeclaredMethods(resource, methods::add, m -> m.getName().equals(method) && annotatedWithPath.test((Method)m));
        return methods;
    }
}

