/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import esa.commons.Checks;
import io.esastack.commons.net.http.MediaTypeUtil;
import io.esastack.restlight.core.util.DateUtils;
import io.esastack.restlight.core.util.HttpHeaderUtils;
import io.esastack.restlight.core.util.LoggerUtils;
import io.esastack.restlight.jaxrs.impl.core.ResponseBuilderImpl;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import io.esastack.restlight.jaxrs.util.MediaTypeUtils;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.stream.Collectors;

public class ResponseImpl
extends Response {
    private static final IllegalStateException UNSUPPORTED_READ = new IllegalStateException("The read operation is unsupported on server side!");
    private static final AtomicIntegerFieldUpdater<ResponseImpl> CLOSED_STATE = AtomicIntegerFieldUpdater.newUpdater(ResponseImpl.class, "closed");
    private final ResponseBuilderImpl builder;
    private volatile int closed = 0;

    ResponseImpl(ResponseBuilderImpl builder) {
        Checks.checkNotNull((Object)((Object)builder), (String)"builder");
        this.builder = builder;
    }

    public void setEntity(Object entity) {
        this.checkClosed();
        this.builder.entity(entity);
    }

    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.checkClosed();
        this.builder.entity(entity, annotations);
        this.builder.headers().putSingle((Object)"content-type", (Object)mediaType);
    }

    public Annotation[] getAnnotations() {
        return this.builder.annotations();
    }

    public void setStatus(int status) {
        this.builder.status(status);
    }

    public void setStatus(Response.StatusType statusInfo) {
        this.builder.status(statusInfo);
    }

    public int getStatus() {
        return this.builder.status().getStatusCode();
    }

    public Response.StatusType getStatusInfo() {
        return Response.Status.fromStatusCode((int)this.getStatus());
    }

    public Object getEntity() {
        this.checkClosed();
        return this.builder.entity();
    }

    public <T> T readEntity(Class<T> entityType) {
        throw UNSUPPORTED_READ;
    }

    public <T> T readEntity(GenericType<T> entityType) {
        throw UNSUPPORTED_READ;
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        throw UNSUPPORTED_READ;
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        throw UNSUPPORTED_READ;
    }

    public boolean hasEntity() {
        this.checkClosed();
        return this.builder.entity() != null;
    }

    public boolean bufferEntity() {
        return false;
    }

    public void close() {
        CLOSED_STATE.compareAndSet(this, 0, 1);
    }

    public MediaType getMediaType() {
        Object mediaType = this.builder.headers().getFirst((Object)"Content-Type");
        if (mediaType == null || mediaType instanceof MediaType) {
            return (MediaType)mediaType;
        }
        if (mediaType instanceof io.esastack.commons.net.http.MediaType) {
            return MediaTypeUtils.convert((io.esastack.commons.net.http.MediaType)mediaType);
        }
        return MediaTypeUtils.convert(MediaTypeUtil.parseMediaType((String)mediaType.toString()));
    }

    public Locale getLanguage() {
        Object language = this.builder.headers().getFirst((Object)"Content-Language");
        if (language == null || language instanceof Locale) {
            return (Locale)language;
        }
        return HttpHeaderUtils.parseToLanguage((String)language.toString());
    }

    public int getLength() {
        int length;
        Object contentLength = this.builder.headers().getFirst((Object)"Content-Length");
        if (contentLength == null) {
            return -1;
        }
        try {
            length = Integer.parseInt(contentLength.toString());
        }
        catch (NumberFormatException ignore) {
            length = -1;
        }
        return length;
    }

    public Set<String> getAllowedMethods() {
        List methods = (List)this.builder.headers().get((Object)"Allow");
        if (methods == null) {
            return Collections.emptySet();
        }
        HashSet<String> methodSet = new HashSet<String>();
        for (Object obj : methods) {
            methodSet.add(obj.toString());
        }
        return methodSet;
    }

    public Map<String, NewCookie> getCookies() {
        List underlying = (List)this.builder.headers().get((Object)"Set-Cookie");
        if (underlying == null) {
            return Collections.emptyMap();
        }
        HashMap<String, NewCookie> cookies = new HashMap<String, NewCookie>();
        for (Object item : underlying) {
            NewCookie newCookie = (NewCookie)RuntimeDelegate.getInstance().createHeaderDelegate(NewCookie.class).fromString(item.toString());
            cookies.put(newCookie.getName(), newCookie);
        }
        return cookies;
    }

    public EntityTag getEntityTag() {
        Object tag = this.builder.headers().getFirst((Object)"ETag");
        if (tag == null || tag instanceof EntityTag) {
            return (EntityTag)tag;
        }
        return (EntityTag)RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class).fromString(tag.toString());
    }

    public Date getDate() {
        Object data = this.builder.headers().getFirst((Object)"Date");
        if (data == null || data instanceof Date) {
            return (Date)data;
        }
        return DateUtils.parseByCache((String)data.toString());
    }

    public Date getLastModified() {
        Object data = this.builder.headers().getFirst((Object)"Last-Modified");
        if (data == null || data instanceof Date) {
            return (Date)data;
        }
        return DateUtils.parseByCache((String)data.toString());
    }

    public URI getLocation() {
        Object location = this.builder.headers().getFirst((Object)"Location");
        if (location == null || location instanceof URI) {
            return (URI)location;
        }
        return URI.create(location.toString());
    }

    public Set<Link> getLinks() {
        HashSet<Link> links = new HashSet<Link>();
        List ls = (List)this.builder.headers().get((Object)"Link");
        if (ls != null) {
            for (Object item : ls) {
                if (item instanceof Link) {
                    links.add((Link)item);
                    continue;
                }
                if (item instanceof String) {
                    links.add(Link.valueOf((String)((String)item)));
                    continue;
                }
                LoggerUtils.logger().warn("Unrecognized header value of 'link': [{}]", item);
            }
        }
        return links;
    }

    public boolean hasLink(String relation) {
        return this.getLink(relation) != null;
    }

    public Link getLink(String relation) {
        if (relation == null) {
            return null;
        }
        for (Link link : this.getLinks()) {
            if (!link.getRel().equals(relation)) continue;
            return link;
        }
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLink(relation);
        return link == null ? null : Link.fromLink((Link)link);
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.builder.headers();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return new StringHeadersMultivaluedMap(this.builder.headers());
    }

    public String getHeaderString(String name) {
        return HttpHeaderUtils.concatHeaderValues((List)((List)this.getStringHeaders().get((Object)name)));
    }

    private void checkClosed() {
        if (CLOSED_STATE.get(this) == 1) {
            throw new IllegalStateException("Response has been closed!");
        }
    }

    static class StringHeadersMultivaluedMap
    implements MultivaluedMap<String, String> {
        private final MultivaluedMap<String, Object> underlying;

        StringHeadersMultivaluedMap(MultivaluedMap<String, Object> underlying) {
            Checks.checkNotNull(underlying, (String)"underlying");
            this.underlying = underlying;
        }

        public void putSingle(String key, String value) {
            this.underlying.putSingle((Object)key, (Object)value);
        }

        public void add(String key, String value) {
            this.underlying.add((Object)key, (Object)value);
        }

        public String getFirst(String key) {
            return JaxrsUtils.toString(this.underlying.getFirst((Object)key));
        }

        public void addAll(String key, String ... newValues) {
            this.underlying.addAll((Object)key, (Object[])newValues);
        }

        public void addAll(String key, List<String> valueList) {
            ArrayList<String> values = null;
            if (valueList != null) {
                values = new ArrayList<String>(valueList);
            }
            this.underlying.addAll((Object)key, values);
        }

        public void addFirst(String key, String value) {
            this.underlying.addFirst((Object)key, (Object)value);
        }

        public boolean equalsIgnoreValueOrder(MultivaluedMap<String, String> otherMap) {
            return JaxrsUtils.equalsIgnoreValueOrder(this.underlying, otherMap);
        }

        public int size() {
            return this.underlying.size();
        }

        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.underlying.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.underlying.containsValue(value);
        }

        public List<String> get(Object key) {
            List previous = (List)this.underlying.get(key);
            if (previous == null) {
                return null;
            }
            return previous.stream().map(JaxrsUtils::toString).collect(Collectors.toList());
        }

        public List<String> put(String key, List<String> value) {
            ArrayList<String> newValue = value == null ? null : new ArrayList<String>(value);
            List previous = (List)this.underlying.put((Object)key, newValue);
            if (previous == null) {
                return null;
            }
            return previous.stream().map(JaxrsUtils::toString).collect(Collectors.toList());
        }

        public List<String> remove(Object key) {
            List previous = (List)this.underlying.remove(key);
            if (previous == null) {
                return null;
            }
            return previous.stream().map(JaxrsUtils::toString).collect(Collectors.toList());
        }

        public void putAll(Map<? extends String, ? extends List<String>> m) {
            LinkedHashMap entries = new LinkedHashMap();
            m.forEach((k, v) -> {
                List cfr_ignored_0 = entries.put(k, v == null ? null : new ArrayList(v));
            });
            this.underlying.putAll(entries);
        }

        public void clear() {
            this.underlying.clear();
        }

        public Set<String> keySet() {
            return this.underlying.keySet();
        }

        public Collection<List<String>> values() {
            ArrayList<List<String>> values = new ArrayList<List<String>>();
            this.underlying.values().forEach(vs -> {
                if (vs == null) {
                    values.add(null);
                } else {
                    values.add(vs.stream().map(JaxrsUtils::toString).collect(Collectors.toList()));
                }
            });
            return values;
        }

        public Set<Map.Entry<String, List<String>>> entrySet() {
            LinkedHashSet<Map.Entry<String, List<String>>> entries = new LinkedHashSet<Map.Entry<String, List<String>>>();
            this.underlying.forEach((key, value) -> entries.add(new Map.Entry<String, List<String>>(){

                @Override
                public String getKey() {
                    return key;
                }

                @Override
                public List<String> getValue() {
                    return value.stream().map(JaxrsUtils::toString).collect(Collectors.toList());
                }

                @Override
                public List<String> setValue(List<String> value2) {
                    Object previous = this.getValue();
                    underlying.put((Object)key, (Object)(value2 == null ? null : new ArrayList<String>(value2)));
                    return previous;
                }
            }));
            return entries;
        }
    }
}

