/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import io.esastack.restlight.jaxrs.impl.core.ResponseImpl;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ResponseBuilderImpl
extends Response.ResponseBuilder {
    private final MultivaluedMap<String, Object> headers = new MultivaluedHashMap();
    private Response.Status status;
    private String reasonPhrase;
    private Object entity;
    private Annotation[] annotations;

    public ResponseBuilderImpl() {
    }

    private ResponseBuilderImpl(ResponseBuilderImpl from) {
        from.headers.forEach((arg_0, arg_1) -> this.headers.addAll(arg_0, arg_1));
        this.status = from.status;
        this.reasonPhrase = from.reasonPhrase;
        this.entity = from.entity;
        this.annotations = from.annotations;
    }

    public Response build() {
        if (this.status == null) {
            this.status = this.entity == null ? Response.Status.NO_CONTENT : Response.Status.OK;
        }
        ResponseImpl response = new ResponseImpl(new ResponseBuilderImpl(this));
        this.reset();
        return response;
    }

    public Response.ResponseBuilder clone() {
        return new ResponseBuilderImpl(this);
    }

    public Response.ResponseBuilder status(int status) {
        if (status < 100 || status > 599) {
            throw new IllegalArgumentException("illegal status: " + status + " (expected:[100, 600))");
        }
        this.status = Response.Status.fromStatusCode((int)status);
        return this;
    }

    public Response.ResponseBuilder status(int status, String reasonPhrase) {
        this.status(status);
        this.reasonPhrase = reasonPhrase;
        return this;
    }

    public Response.ResponseBuilder entity(Object entity) {
        this.entity = entity;
        return this;
    }

    public Response.ResponseBuilder entity(Object entity, Annotation[] annotations) {
        this.entity = entity;
        this.annotations = annotations;
        return this;
    }

    public Response.ResponseBuilder allow(String ... methods) {
        HashSet<String> methodsSet = null;
        if (methods != null) {
            methodsSet = new HashSet<String>();
            for (String method : methods) {
                methodsSet.add(method.toUpperCase());
            }
        }
        LinkedList methodList = null;
        if (methodsSet != null) {
            methodList = new LinkedList(methodsSet);
        }
        return this.addHeaders("Allow", methodList);
    }

    public Response.ResponseBuilder allow(Set<String> methods) {
        HashSet methodsSet;
        if (methods == null) {
            methodsSet = null;
        } else {
            methodsSet = new HashSet();
            methods.forEach(m -> methodsSet.add(m.toUpperCase()));
        }
        LinkedList methodList = null;
        if (methodsSet != null) {
            methodList = new LinkedList(methodsSet);
        }
        return this.addHeaders("Allow", methodList);
    }

    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        return this.setHeader("Cache-Control", cacheControl);
    }

    public Response.ResponseBuilder encoding(String encoding) {
        return this.setHeader("Content-Encoding", encoding);
    }

    public Response.ResponseBuilder header(String name, Object value) {
        return this.addHeader(name, value);
    }

    public Response.ResponseBuilder replaceAll(MultivaluedMap<String, Object> headers) {
        this.headers.clear();
        if (headers == null) {
            return this;
        }
        headers.forEach((arg_0, arg_1) -> this.headers.put(arg_0, arg_1));
        return this;
    }

    public Response.ResponseBuilder language(String language) {
        return this.setHeader("Content-Language", language);
    }

    public Response.ResponseBuilder language(Locale language) {
        return this.setHeader("Content-Language", language);
    }

    public Response.ResponseBuilder type(MediaType type) {
        return this.setHeader("Content-Type", type);
    }

    public Response.ResponseBuilder type(String type) {
        return this.setHeader("Content-Type", type);
    }

    public Response.ResponseBuilder variant(Variant variant) {
        if (variant == null) {
            this.setHeader("Content-Encoding", null);
            this.setHeader("Content-Language", null);
            return this.setHeader("Content-Type", null);
        }
        this.setHeader("Content-Encoding", variant.getEncoding());
        this.setHeader("Content-Language", variant.getLanguage());
        return this.setHeader("Content-Type", variant.getMediaType());
    }

    public Response.ResponseBuilder contentLocation(URI location) {
        return this.setHeader("Content-Location", location);
    }

    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        LinkedList<Object> cookiesList = null;
        if (cookies != null) {
            cookiesList = new LinkedList<Object>();
            Collections.addAll(cookiesList, cookies);
        }
        return this.addHeaders("Set-Cookie", cookiesList);
    }

    public Response.ResponseBuilder expires(Date expires) {
        return this.setHeader("Expires", expires);
    }

    public Response.ResponseBuilder lastModified(Date lastModified) {
        return this.setHeader("Last-Modified", lastModified);
    }

    public Response.ResponseBuilder location(URI location) {
        if (location == null) {
            return this.setHeader("Location", null);
        }
        return this.setHeader("Location", location);
    }

    public Response.ResponseBuilder tag(EntityTag tag) {
        return this.setHeader("ETag", tag);
    }

    public Response.ResponseBuilder tag(String tag) {
        return this.tag(tag == null ? null : new EntityTag(tag));
    }

    public Response.ResponseBuilder variants(Variant ... variants) {
        LinkedList<Object> variantList = null;
        if (variants != null) {
            variantList = new LinkedList<Object>();
            Collections.addAll(variantList, variants);
        }
        return this.addHeaders("Vary", variantList);
    }

    public Response.ResponseBuilder variants(List<Variant> variants) {
        return this.addHeaders("Vary", (List<Object>)(variants != null ? new LinkedList<Variant>(variants) : null));
    }

    public Response.ResponseBuilder links(Link ... links) {
        LinkedList linksList = null;
        if (links != null) {
            linksList = new LinkedList();
            Collections.addAll(linksList, links);
        }
        return this.addHeaders("Link", linksList != null ? new LinkedList(linksList) : null);
    }

    public Response.ResponseBuilder link(URI uri, String rel) {
        return this.addHeader("Link", Link.fromUri((URI)uri).rel(rel).build(new Object[0]));
    }

    public Response.ResponseBuilder link(String uri, String rel) {
        return this.addHeader("Link", Link.fromUri((String)uri).rel(rel).build(new Object[0]));
    }

    MultivaluedMap<String, Object> headers() {
        return this.headers;
    }

    Object entity() {
        return this.entity;
    }

    Response.Status status() {
        return this.status;
    }

    Annotation[] annotations() {
        return this.annotations;
    }

    String reasonPhrase() {
        return this.reasonPhrase;
    }

    private void reset() {
        this.headers.clear();
        this.entity = null;
        this.annotations = null;
        this.reasonPhrase = null;
        this.status(Response.Status.OK);
    }

    private Response.ResponseBuilder setHeader(String name, Object value) {
        if (value == null) {
            this.headers.remove((Object)name);
        } else {
            this.headers.putSingle((Object)name, value);
        }
        return this;
    }

    private Response.ResponseBuilder addHeader(String name, Object value) {
        if (value == null) {
            this.headers.remove((Object)name);
        } else {
            this.headers.add((Object)name, value);
        }
        return this;
    }

    private Response.ResponseBuilder addHeaders(String name, List<Object> values) {
        if (values == null) {
            this.headers.remove((Object)name);
        } else {
            this.headers.addAll((Object)name, values);
        }
        return this;
    }
}

