/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import esa.commons.Checks;
import esa.commons.StringUtils;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.commons.net.http.HttpMethod;
import io.esastack.commons.net.http.HttpStatus;
import io.esastack.commons.net.http.MediaTypeUtil;
import io.esastack.restlight.core.context.HttpRequest;
import io.esastack.restlight.core.context.HttpResponse;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.core.util.DateUtils;
import io.esastack.restlight.core.util.HttpHeaderUtils;
import io.esastack.restlight.jaxrs.util.MediaTypeUtils;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class RequestImpl
implements Request {
    private final HttpRequest request;
    private final HttpResponse response;
    private String varyHeader;

    public RequestImpl(RequestContext context) {
        Checks.checkNotNull((Object)context, (String)"context");
        this.request = context.request();
        this.response = context.response();
    }

    public String getMethod() {
        return this.request.rawMethod();
    }

    public Variant selectVariant(List<Variant> variants) {
        Checks.checkNotEmptyArg(variants, (String)"variants");
        this.varyHeader = RequestImpl.createVaryHeader(variants);
        this.response.headers().add("vary", (Object)this.varyHeader);
        return VariantMatcher.INSTANCE.match(this.request, variants);
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        List ifNoneMatches;
        Checks.checkArg((eTag != null ? 1 : 0) != 0, (String)"eTage");
        Response.ResponseBuilder builder = null;
        List ifMatches = this.request.headers().getAll("if-match");
        if (ifMatches != null && !ifMatches.isEmpty()) {
            builder = RequestImpl.ifMatch(RequestImpl.toETags(ifMatches), eTag);
        }
        if (builder == null && (ifNoneMatches = this.request.headers().getAll("if-none-match")) != null && !ifNoneMatches.isEmpty()) {
            builder = this.ifNoneMatch(RequestImpl.toETags(ifNoneMatches), eTag);
        }
        if (builder != null) {
            builder.tag(eTag);
        }
        return this.addVaryHeader(builder);
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        String ifUnmodifiedSince;
        Checks.checkArg((lastModified != null ? 1 : 0) != 0, (String)"lastModified");
        Response.ResponseBuilder builder = null;
        String ifModifiedSince = this.request.headers().get("if-modified-since");
        if (ifModifiedSince != null && !this.request.headers().contains("if-none-match")) {
            builder = RequestImpl.ifModifiedSince(ifModifiedSince, lastModified);
        }
        if (builder == null && (ifUnmodifiedSince = this.request.headers().get("if-unmodified-since")) != null && !this.request.headers().contains("if-match")) {
            builder = RequestImpl.ifUnmodifiedSince(ifUnmodifiedSince, lastModified);
        }
        return this.addVaryHeader(builder);
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        Response.ResponseBuilder rstBuilder;
        Response.ResponseBuilder eTageBuilder = this.evaluatePreconditions(eTag);
        Response.ResponseBuilder lastModifiedBuilder = this.evaluatePreconditions(lastModified);
        if (eTageBuilder == null && lastModifiedBuilder == null) {
            return null;
        }
        if (eTageBuilder != null && lastModifiedBuilder == null) {
            rstBuilder = eTageBuilder;
        } else if (eTageBuilder == null) {
            rstBuilder = lastModifiedBuilder;
        } else {
            rstBuilder = lastModifiedBuilder;
            rstBuilder.tag(eTag);
        }
        return this.addVaryHeader(rstBuilder);
    }

    public Response.ResponseBuilder evaluatePreconditions() {
        List ifMatches = this.request.headers().getAll("if-match");
        if (ifMatches == null || ifMatches.isEmpty()) {
            return null;
        }
        return Response.status((int)HttpStatus.PRECONDITION_FAILED.code());
    }

    private Response.ResponseBuilder addVaryHeader(Response.ResponseBuilder builder) {
        if (builder != null && this.varyHeader != null) {
            builder.header("vary", (Object)this.varyHeader);
        }
        return builder;
    }

    private Response.ResponseBuilder ifNoneMatch(List<EntityTag> ifNoneMatch, EntityTag eTag) {
        boolean match = false;
        for (EntityTag tag : ifNoneMatch) {
            if (!tag.equals((Object)eTag) && !tag.getValue().equals("*")) continue;
            match = true;
            break;
        }
        if (match) {
            HttpMethod method = this.request.method();
            if (HttpMethod.GET.equals((Object)method) || HttpMethod.HEAD.equals((Object)method)) {
                return Response.notModified((EntityTag)eTag);
            }
            return Response.status((int)HttpStatus.PRECONDITION_FAILED.code());
        }
        return null;
    }

    private static Response.ResponseBuilder ifMatch(List<EntityTag> ifMatch, EntityTag eTag) {
        for (EntityTag tag : ifMatch) {
            if (!tag.equals((Object)eTag) && !tag.getValue().equals("*")) continue;
            return null;
        }
        return Response.status((int)HttpStatus.PRECONDITION_FAILED.code());
    }

    private static List<EntityTag> toETags(List<String> eTags) {
        LinkedList<EntityTag> tags = new LinkedList<EntityTag>();
        RuntimeDelegate.HeaderDelegate delegate = RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class);
        if (delegate == null) {
            throw new IllegalStateException("Failed to get HeaderDelegate to resolve EntityTag.");
        }
        for (String eTag : eTags) {
            Arrays.stream(eTag.split(",")).forEach(item -> tags.add((EntityTag)delegate.fromString(StringUtils.trim((String)item))));
        }
        return tags;
    }

    private static Response.ResponseBuilder ifUnmodifiedSince(String strDate, Date lastModified) {
        Date date = DateUtils.parseByCache((String)strDate);
        if (!date.before(lastModified)) {
            return null;
        }
        return Response.status((int)HttpStatus.PRECONDITION_FAILED.code()).lastModified(lastModified);
    }

    private static Response.ResponseBuilder ifModifiedSince(String strDate, Date lastModified) {
        Date date = DateUtils.parseByCache((String)strDate);
        if (!date.before(lastModified)) {
            return Response.notModified();
        }
        return null;
    }

    private static String createVaryHeader(List<Variant> variants) {
        boolean acceptLanguage = false;
        boolean accept = false;
        boolean acceptEncoding = false;
        for (Variant variant : variants) {
            if (variant.getLanguage() != null) {
                acceptLanguage = true;
            }
            if (variant.getMediaType() != null) {
                accept = true;
            }
            if (variant.getEncoding() == null) continue;
            acceptEncoding = true;
        }
        StringBuilder builder = new StringBuilder();
        boolean emptyBuilder = true;
        if (accept) {
            builder.append("accept");
            emptyBuilder = false;
        }
        if (acceptLanguage) {
            if (!emptyBuilder) {
                builder.append(",");
            }
            builder.append("accept-language");
            emptyBuilder = false;
        }
        if (acceptEncoding) {
            if (!emptyBuilder) {
                builder.append(",");
            }
            builder.append("accept-encoding");
        }
        return builder.toString();
    }

    private static boolean isAcceptEncodingMatched(List<String> acceptEncodings, String target) {
        if (acceptEncodings.isEmpty()) {
            return true;
        }
        for (String encoding : acceptEncodings) {
            if (!"*".equals(encoding) && !encoding.equals(target)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAcceptLanguagesMatched(List<Locale> acceptLanguages, Locale target) {
        if (acceptLanguages.isEmpty()) {
            return true;
        }
        for (Locale locale : acceptLanguages) {
            String language = locale.getLanguage();
            if (!"*".equals(language) && !language.equalsIgnoreCase(target.getLanguage())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMediaTypeMatched(List<io.esastack.commons.net.http.MediaType> accepts, MediaType target) {
        if (accepts.isEmpty()) {
            return true;
        }
        io.esastack.commons.net.http.MediaType converted = MediaTypeUtils.convert(target);
        for (io.esastack.commons.net.http.MediaType accept : accepts) {
            if (!accept.isCompatibleWith(converted)) continue;
            return true;
        }
        return false;
    }

    private static class VariantComparator
    implements Comparator<Variant> {
        private static final VariantComparator INSTANCE = new VariantComparator();

        private VariantComparator() {
        }

        @Override
        public int compare(Variant o1, Variant o2) {
            io.esastack.commons.net.http.MediaType converted2;
            io.esastack.commons.net.http.MediaType converted1 = MediaTypeUtils.convert(o1.getMediaType());
            int value = MediaTypeUtil.SPECIFICITY_COMPARATOR.compare(converted1, converted2 = MediaTypeUtils.convert(o2.getMediaType()));
            if (value != 0) {
                return value;
            }
            value = VariantComparator.compareLanguage(o1.getLanguage(), o2.getLanguage());
            if (value != 0) {
                return value;
            }
            return VariantComparator.compareEncoding(o1.getEncoding(), o2.getEncoding());
        }

        private static int compareEncoding(String encoding1, String encoding2) {
            return VariantComparator.compareString(encoding1, encoding2);
        }

        private static int compareLanguage(Locale local1, Locale local2) {
            if (local1 == null && local2 == null) {
                return 0;
            }
            if (local1 == null) {
                return 1;
            }
            if (local2 == null) {
                return -1;
            }
            int value = VariantComparator.compareString(local1.getLanguage(), local2.getLanguage());
            return value != 0 ? value : VariantComparator.compareString(local1.getCountry(), local2.getCountry());
        }

        private static int compareString(String v1, String v2) {
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null) {
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            if (v1.equals("*")) {
                return 1;
            }
            if (v2.equals("*")) {
                return -1;
            }
            return 0;
        }
    }

    private static class VariantMatcher {
        private static final VariantMatcher INSTANCE = new VariantMatcher();

        private VariantMatcher() {
        }

        private Variant match(HttpRequest request, List<Variant> variants) {
            List acceptEncodings = HttpHeaderUtils.getAcceptEncodings((HttpHeaders)request.headers());
            List acceptLanguages = HttpHeaderUtils.getAcceptLanguages((HttpHeaders)request.headers());
            List accepts = request.accepts();
            LinkedList<Variant> matched = new LinkedList<Variant>();
            for (Variant variant : variants) {
                if (!RequestImpl.isAcceptEncodingMatched(acceptEncodings, variant.getEncoding()) || !RequestImpl.isAcceptLanguagesMatched(acceptLanguages, variant.getLanguage()) || !RequestImpl.isMediaTypeMatched(accepts, variant.getMediaType())) continue;
                matched.add(variant);
            }
            if (matched.isEmpty()) {
                return null;
            }
            matched.sort(VariantComparator.INSTANCE);
            return (Variant)matched.get(0);
        }
    }
}

