/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import esa.commons.Checks;
import esa.commons.StringUtils;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import java.util.Arrays;
import java.util.stream.Collectors;

public class PathSegmentImpl
implements PathSegment {
    private final String segment;
    private String path;
    private MultivaluedMap<String, String> params;

    public PathSegmentImpl(String segment) {
        Checks.checkNotEmptyArg((String)segment, (String)"segment");
        this.segment = segment;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.segment.substring(0, this.segment.indexOf(";"));
            if (this.path.startsWith("/")) {
                this.path = this.path.substring(1);
            }
        }
        return this.path;
    }

    public MultivaluedMap<String, String> getMatrixParameters() {
        if (this.params == null) {
            String[] subSegments = this.segment.split(";");
            MultivaluedHashMap values = new MultivaluedHashMap(subSegments.length - 1);
            for (int i = 1; i < subSegments.length; ++i) {
                String[] nav = subSegments[i].split("=");
                String[] vs = nav[1].split(",");
                values.addAll((Object)StringUtils.trim((String)nav[0]), Arrays.stream(vs).map(StringUtils::trim).collect(Collectors.toList()));
            }
            this.params = values;
        }
        MultivaluedHashMap copied = new MultivaluedHashMap();
        copied.putAll(this.params);
        return copied;
    }
}

