/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import esa.commons.Checks;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ModifiableMultivaluedMap
implements MultivaluedMap<String, String> {
    private final HttpHeaders underlying;

    public ModifiableMultivaluedMap(HttpHeaders underlying) {
        Checks.checkNotNull((Object)underlying, (String)"underlying");
        this.underlying = underlying;
    }

    public void putSingle(String key, String value) {
        this.underlying.set(key, (Object)value);
    }

    public void add(String key, String value) {
        this.underlying.add(key, (Object)value);
    }

    public String getFirst(String key) {
        return this.underlying.get(key);
    }

    public void addAll(String key, String ... newValues) {
        Checks.checkNotNull((Object)newValues, (String)"newValues");
        for (String newValue : newValues) {
            this.underlying.add(key, (Object)newValue);
        }
    }

    public void addAll(String key, List<String> valueList) {
        Checks.checkNotNull(valueList, (String)"valueList");
        this.underlying.add(key, valueList);
    }

    public void addFirst(String key, String value) {
        List previous = this.underlying.getAll(key);
        ArrayList<String> current = previous == null || previous.isEmpty() ? new ArrayList<String>() : new ArrayList(previous);
        current.add(0, value);
        this.underlying.set(key, current);
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<String, String> otherMap) {
        return JaxrsUtils.equalsIgnoreValueOrder(this, otherMap);
    }

    public int size() {
        return this.underlying.size();
    }

    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    public boolean containsKey(Object key) {
        Checks.checkNotNull((Object)key, (String)"key");
        for (String name : this.underlying.names()) {
            if (!name.equals(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        Checks.checkNotNull((Object)value, (String)"value");
        for (String name : this.underlying.names()) {
            List values = this.underlying.getAll(name);
            if (values == null || !values.contains(value)) continue;
            return true;
        }
        return false;
    }

    public List<String> get(Object key) {
        Checks.checkNotNull((Object)key, (String)"key");
        return this.underlying.getAll(key.toString());
    }

    public List<String> put(String key, List<String> value) {
        List previous = this.underlying.getAll(key);
        this.underlying.set(key, value);
        return previous;
    }

    public List<String> remove(Object key) {
        Checks.checkNotNull((Object)key, (String)"key");
        List previous = this.underlying.getAll(key.toString());
        this.underlying.remove(key.toString());
        return previous;
    }

    public void putAll(Map<? extends String, ? extends List<String>> m) {
        for (Map.Entry<? extends String, ? extends List<String>> entry : m.entrySet()) {
            List<String> values = entry.getValue();
            if (values == null) continue;
            ArrayList<String> newValue = new ArrayList<String>(values);
            List v = this.underlying.getAll(entry.getKey());
            if (v != null) {
                newValue.addAll(v);
            }
            this.underlying.set(entry.getKey(), newValue);
        }
    }

    public void clear() {
        this.underlying.clear();
    }

    public Set<String> keySet() {
        return this.underlying.names();
    }

    public Collection<List<String>> values() {
        LinkedList<List<String>> values = new LinkedList<List<String>>();
        for (Map.Entry<String, List<String>> entry : this.entrySet()) {
            values.add(entry.getValue());
        }
        return values;
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        LinkedHashSet<Map.Entry<String, List<String>>> entries = new LinkedHashSet<Map.Entry<String, List<String>>>();
        for (final String name : this.underlying.names()) {
            entries.add(new Map.Entry<String, List<String>>(){

                @Override
                public String getKey() {
                    return name;
                }

                @Override
                public List<String> getValue() {
                    return ModifiableMultivaluedMap.this.underlying.getAll(name);
                }

                @Override
                public List<String> setValue(List<String> value) {
                    Object previous = this.getValue();
                    ModifiableMultivaluedMap.this.underlying.set(name, value);
                    return previous;
                }
            });
        }
        return entries;
    }
}

