/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import esa.commons.Checks;
import esa.commons.StringUtils;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LinkImpl
extends Link {
    private final URI uri;
    private final Map<String, String> params;
    private String strVal;

    public LinkImpl(URI uri, Map<String, String> params) {
        Checks.checkNotNull((Object)uri, (String)"uri");
        Checks.checkNotNull(params, (String)"params");
        this.uri = uri;
        this.params = params.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(params);
    }

    public URI getUri() {
        return this.uri;
    }

    public UriBuilder getUriBuilder() {
        return UriBuilder.fromUri((URI)this.uri);
    }

    public String getRel() {
        return this.params.get("rel");
    }

    public List<String> getRels() {
        String rels = this.params.get("rel");
        return StringUtils.isEmpty((String)rels) ? Collections.emptyList() : Arrays.asList(rels.split(" "));
    }

    public String getTitle() {
        return this.params.get("title");
    }

    public String getType() {
        return this.params.get("type");
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LinkImpl link = (LinkImpl)((Object)o);
        return Objects.equals(this.uri, link.uri) && Objects.equals(this.params, link.params);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.params);
    }

    public String toString() {
        if (this.strVal != null) {
            return this.strVal;
        }
        RuntimeDelegate.HeaderDelegate delegate = RuntimeDelegate.getInstance().createHeaderDelegate(Link.class);
        this.strVal = delegate.toString((Object)this);
        return this.strVal;
    }
}

