/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import esa.commons.Checks;
import io.esastack.restlight.jaxrs.impl.core.LinkImpl;
import io.esastack.restlight.jaxrs.impl.core.UriInfoImpl;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class LinkBuilderImpl
implements Link.Builder {
    private final Map<String, String> params = new HashMap<String, String>();
    private UriBuilder uriBuilder;
    private URI baseUri;

    public Link.Builder link(Link link) {
        this.uriBuilder = UriBuilder.fromLink((Link)link);
        this.params.putAll(link.getParams());
        return this;
    }

    public Link.Builder link(String link) {
        Link l = (Link)RuntimeDelegate.getInstance().createHeaderDelegate(Link.class).fromString(link);
        if (l != null) {
            this.uriBuilder = l.getUriBuilder();
            this.params.putAll(l.getParams());
        }
        return this;
    }

    public Link.Builder uri(URI uri) {
        Checks.checkArg((uri != null ? 1 : 0) != 0, (String)"uri is null");
        this.uriBuilder = UriBuilder.fromUri((URI)uri);
        return this;
    }

    public Link.Builder uri(String uri) {
        this.uriBuilder = UriBuilder.fromUri((String)uri);
        return this;
    }

    public Link.Builder baseUri(URI uri) {
        this.baseUri = uri;
        return this;
    }

    public Link.Builder baseUri(String uri) {
        this.baseUri = URI.create(uri);
        return this;
    }

    public Link.Builder uriBuilder(UriBuilder uriBuilder) {
        Checks.checkArg((uriBuilder != null ? 1 : 0) != 0, (String)"uriBuilder is null");
        this.uriBuilder = uriBuilder;
        return this;
    }

    public Link.Builder rel(String rel) {
        if (rel == null) {
            throw new IllegalArgumentException("rel is null");
        }
        String rels = this.params.get("rel");
        this.param("rel", rels == null ? rel : rels + " " + rel);
        return this;
    }

    public Link.Builder title(String title) {
        if (title == null) {
            throw new IllegalArgumentException("title is null");
        }
        this.param("title", title);
        return this;
    }

    public Link.Builder type(String type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.param("type", type);
        return this;
    }

    public Link.Builder param(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.params.put(name, value);
        return this;
    }

    public Link build(Object ... values) {
        return new LinkImpl(this.getResolvedUri(values), new HashMap<String, String>(this.params));
    }

    public Link buildRelativized(URI uri, Object ... values) {
        URI resolved = this.getResolvedUri(values);
        return new LinkImpl(UriInfoImpl.relativize(uri, resolved), new HashMap<String, String>(this.params));
    }

    private URI getResolvedUri(Object ... values) {
        URI uri = this.uriBuilder.build(values);
        if (this.baseUri != null) {
            UriBuilder linkUriBuilder = UriBuilder.fromUri((URI)this.baseUri);
            String scheme = uri.getScheme();
            if (scheme != null && scheme.startsWith("http")) {
                if (!uri.isAbsolute()) {
                    return linkUriBuilder.build(new Object[0]).resolve(uri);
                }
                return uri;
            }
            String theUri = uri.toString();
            return linkUriBuilder.path(theUri).build(new Object[0]);
        }
        return uri;
    }
}

