/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import esa.commons.Checks;
import io.esastack.commons.net.http.Cookie;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.commons.net.http.MediaType;
import io.esastack.restlight.core.context.HttpRequest;
import io.esastack.restlight.core.util.DateUtils;
import io.esastack.restlight.core.util.HttpHeaderUtils;
import io.esastack.restlight.jaxrs.impl.core.ModifiableMultivaluedMap;
import io.esastack.restlight.jaxrs.util.MediaTypeUtils;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class HttpRequestHeaders
implements jakarta.ws.rs.core.HttpHeaders {
    private final HttpRequest request;
    private final ModifiableMultivaluedMap headers;

    public HttpRequestHeaders(HttpRequest request) {
        Checks.checkNotNull((Object)request, (String)"request");
        this.request = request;
        this.headers = new ModifiableMultivaluedMap(request.headers());
    }

    public List<String> getRequestHeader(String name) {
        return this.headers.get(name);
    }

    public String getHeaderString(String name) {
        return HttpHeaderUtils.concatHeaderValues(this.getRequestHeader(name));
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.headers;
    }

    public List<jakarta.ws.rs.core.MediaType> getAcceptableMediaTypes() {
        List mediaTypes = this.request.accepts();
        ArrayList<jakarta.ws.rs.core.MediaType> values = new ArrayList<jakarta.ws.rs.core.MediaType>(mediaTypes.size());
        for (MediaType mediaType : mediaTypes) {
            values.add(MediaTypeUtils.convert(mediaType));
        }
        return values;
    }

    public List<Locale> getAcceptableLanguages() {
        return HttpHeaderUtils.getAcceptLanguages((HttpHeaders)this.request.headers());
    }

    public jakarta.ws.rs.core.MediaType getMediaType() {
        return MediaTypeUtils.convert(this.request.contentType());
    }

    public Locale getLanguage() {
        String language = this.headers.getFirst("Content-Language");
        return HttpHeaderUtils.parseToLanguage((String)language);
    }

    public Map<String, jakarta.ws.rs.core.Cookie> getCookies() {
        Set underlying = this.request.cookies();
        if (underlying.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, jakarta.ws.rs.core.Cookie> cookies = new HashMap<String, jakarta.ws.rs.core.Cookie>(underlying.size());
        for (Cookie cookie : underlying) {
            cookies.put(cookie.name(), new jakarta.ws.rs.core.Cookie(cookie.name(), cookie.value(), cookie.path(), cookie.domain()));
        }
        return cookies;
    }

    public Date getDate() {
        String data = this.headers.getFirst("Date");
        return DateUtils.parseByCache((String)data);
    }

    public int getLength() {
        return (int)this.request.contentLength();
    }
}

