/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import esa.commons.Checks;
import esa.commons.ClassUtils;
import esa.commons.logging.Logger;
import esa.commons.logging.LoggerFactory;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.FeatureContext;
import java.util.Map;

public class FeatureContextImpl
implements FeatureContext {
    private static final Logger logger = LoggerFactory.getLogger(FeatureContextImpl.class);
    private final Class<?> featureType;
    private final Configurable<? extends Configurable<?>> underlying;

    public FeatureContextImpl(Class<?> featureType, Configurable<? extends Configurable<?>> underlying) {
        Checks.checkNotNull(featureType, (String)"featureType");
        Checks.checkNotNull(underlying, (String)"underlying");
        this.featureType = featureType;
        this.underlying = underlying;
    }

    public Configuration getConfiguration() {
        return this.underlying.getConfiguration();
    }

    public FeatureContext property(String name, Object value) {
        this.underlying.property(name, value);
        return this;
    }

    public FeatureContext register(Class<?> componentClass) {
        this.checkState(componentClass);
        this.underlying.register(componentClass);
        return this;
    }

    public FeatureContext register(Class<?> componentClass, int priority) {
        this.checkState(componentClass);
        this.underlying.register(componentClass, priority);
        return this;
    }

    public FeatureContext register(Class<?> componentClass, Class<?> ... contracts) {
        this.checkState(componentClass, contracts);
        this.underlying.register(componentClass, (Class[])contracts);
        return this;
    }

    public FeatureContext register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.checkState(componentClass, contracts);
        this.underlying.register(componentClass, contracts);
        return this;
    }

    public FeatureContext register(Object component) {
        this.checkState(component);
        this.underlying.register(component);
        return this;
    }

    public FeatureContext register(Object component, int priority) {
        this.checkState(component);
        this.underlying.register(component, priority);
        return this;
    }

    public FeatureContext register(Object component, Class<?> ... contracts) {
        this.checkState(component, contracts);
        this.underlying.register(component, (Class[])contracts);
        return this;
    }

    public FeatureContext register(Object component, Map<Class<?>, Integer> contracts) {
        this.checkState(component, contracts);
        this.underlying.register(component, contracts);
        return this;
    }

    private void checkState(Object component) {
        Class userType = ClassUtils.getUserType((Object)component);
        if (JaxrsUtils.isFeature(userType)) {
            logger.warn("Registering nested feature({}) in feature({}) is unsupported.", (Object)userType, this.featureType);
        }
    }

    private void checkState(Object component, Class<?> ... contracts) {
        if (contracts == null) {
            return;
        }
        for (Class<?> userType : contracts) {
            if (!JaxrsUtils.isFeature(userType)) continue;
            logger.warn("Registering nested feature({}) in feature({}) is unsupported.", (Object)ClassUtils.getUserType((Object)component), this.featureType);
        }
    }

    private void checkState(Object component, Map<Class<?>, Integer> contracts) {
        if (contracts == null) {
            return;
        }
        for (Class<?> userType : contracts.keySet()) {
            if (!JaxrsUtils.isFeature(userType)) continue;
            logger.warn("Registering nested feature({}) in feature({}) is unsupported.", (Object)ClassUtils.getUserType((Object)component), this.featureType);
        }
    }
}

