/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import esa.commons.Checks;
import esa.commons.ClassUtils;
import esa.commons.logging.Logger;
import esa.commons.logging.LoggerFactory;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigurationImpl
implements Configuration {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationImpl.class);
    private final Set<Class<?>> classes = new HashSet();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<Class<?>, Map<Class<?>, Integer>> contracts = new HashMap();
    private final List<Object> enabledFeatures = new LinkedList<Object>();
    private final Set<Class<?>> resourcesClasses = new HashSet();
    private final Set<Object> resourcesInstances = new HashSet<Object>();
    private final List<Class<?>> providerClasses = new LinkedList();
    private final List<Object> providerInstances = new LinkedList<Object>();

    public ConfigurationImpl(ConfigurationImpl from) {
        this.classes.addAll(from.classes);
        this.properties.putAll(from.properties);
        this.contracts.putAll(from.contracts);
        this.enabledFeatures.addAll(from.enabledFeatures);
        this.resourcesClasses.addAll(from.resourcesClasses);
        this.resourcesInstances.addAll(from.resourcesInstances);
        this.providerClasses.addAll(from.providerClasses);
        this.providerInstances.addAll(from.providerInstances);
    }

    public ConfigurationImpl() {
    }

    public RuntimeType getRuntimeType() {
        return RuntimeType.SERVER;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<String> getPropertyNames() {
        return Collections.unmodifiableCollection(this.properties.keySet());
    }

    public boolean isEnabled(Feature feature) {
        for (Object f : this.enabledFeatures) {
            if (!f.equals(feature)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(Class<? extends Feature> featureClass) {
        for (Object f : this.enabledFeatures) {
            if (!featureClass.equals(ClassUtils.getUserType((Object)f))) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistered(Object component) {
        for (Object instance : this.getProviderInstances()) {
            if (!instance.equals(component)) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistered(Class<?> componentClass) {
        for (Object object : this.getProviderInstances()) {
            if (!ClassUtils.getUserType((Object)object).equals(componentClass)) continue;
            return true;
        }
        for (Class clazz : this.getProviderClasses()) {
            if (!clazz.equals(componentClass)) continue;
            return true;
        }
        return false;
    }

    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        Map<Class<?>, Integer> values = this.contracts.get(componentClass);
        return values == null ? Collections.emptyMap() : Collections.unmodifiableMap(values);
    }

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet(this.resourcesClasses);
        classes.addAll(this.providerClasses);
        return Collections.unmodifiableSet(classes);
    }

    public Set<Object> getInstances() {
        HashSet<Object> instances = new HashSet<Object>(this.resourcesInstances);
        instances.addAll(this.providerInstances);
        return Collections.unmodifiableSet(instances);
    }

    public void setProperty(String name, Object value) {
        Checks.checkNotNull((Object)value, (String)"value");
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public Collection<Class<?>> getProviderClasses() {
        return Collections.unmodifiableList(this.providerClasses);
    }

    public Collection<Object> getProviderInstances() {
        return Collections.unmodifiableList(this.providerInstances);
    }

    public void addEnabledFeature(Object feature) {
        Class target = ClassUtils.getUserType((Object)feature);
        if (Feature.class.isAssignableFrom(ClassUtils.getUserType((Object)feature))) {
            this.enabledFeatures.add(feature);
        } else {
            logger.error("Failed to register {} as Feature.", (Object)target);
        }
    }

    public void addResourceClass(Class<?> clazz) {
        if (this.checkState(clazz, false)) {
            return;
        }
        if (JaxrsUtils.isRootResource(clazz)) {
            this.resourcesClasses.add(clazz);
        } else {
            logger.error("Failed to register {} as Resource.", clazz);
        }
    }

    public void addResourceInstance(Object instance) {
        Class clazz = ClassUtils.getUserType((Object)instance);
        if (this.checkState(clazz, false)) {
            return;
        }
        if (JaxrsUtils.isRootResource(clazz)) {
            this.resourcesInstances.add(instance);
        } else {
            logger.warn("Registering {}(unrecognized resource) is ignored.", (Object)clazz);
        }
    }

    public void addProviderInstance(Object instance, Map<Class<?>, Integer> contracts) {
        Class target = ClassUtils.getUserType((Object)instance);
        if (this.checkState(target, true)) {
            return;
        }
        Map<Class<?>, Integer> checked = this.checkContracts(target, contracts);
        if (!checked.isEmpty()) {
            this.providerInstances.add(instance);
            this.contracts.put(target, checked);
        } else {
            logger.error("Failed to register {} as Provider.", (Object)target);
        }
    }

    public void addProviderClass(Class<?> target, Map<Class<?>, Integer> contracts) {
        if (this.checkState(target, true)) {
            return;
        }
        Map<Class<?>, Integer> checked = this.checkContracts(target, contracts);
        if (!checked.isEmpty()) {
            this.providerClasses.add(target);
            this.contracts.put(target, checked);
        } else {
            logger.warn("Registering {}(unrecognized provider) is ignored.", target);
        }
    }

    private Map<Class<?>, Integer> checkContracts(Class<?> target, Map<Class<?>, Integer> contracts) {
        HashMap checked = new HashMap();
        for (Map.Entry<Class<?>, Integer> entry : contracts.entrySet()) {
            if (!entry.getKey().isAssignableFrom(target)) {
                logger.warn("Failed to register {} as {}", target, entry.getKey());
                continue;
            }
            checked.put(entry.getKey(), entry.getValue());
        }
        return checked;
    }

    private boolean checkState(Class<?> clazz, boolean checkConstrain) {
        if (checkConstrain && !JaxrsUtils.isServerSide(clazz)) {
            return true;
        }
        if (!this.classes.add(clazz)) {
            logger.warn("Registering {}(which has been registered before) is ignored.", clazz);
            return true;
        }
        return false;
    }
}

