/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.core;

import esa.commons.Checks;
import esa.commons.ClassUtils;
import esa.commons.logging.Logger;
import esa.commons.logging.LoggerFactory;
import io.esastack.restlight.jaxrs.impl.core.ConfigurationImpl;
import io.esastack.restlight.jaxrs.util.JaxrsUtils;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Configuration;
import java.util.HashMap;
import java.util.Map;

public class ConfigurableImpl
implements Configurable<ConfigurableImpl> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurableImpl.class);
    private final ConfigurationImpl configuration;

    public ConfigurableImpl(ConfigurationImpl configuration) {
        Checks.checkNotNull((Object)configuration, (String)"configuration");
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ConfigurableImpl property(String name, Object value) {
        if (value == null) {
            this.configuration.removeProperty(name);
        } else {
            this.configuration.setProperty(name, value);
        }
        return this;
    }

    public ConfigurableImpl register(Class<?> componentClass) {
        if (componentClass == null) {
            return this;
        }
        return this.register((Class)componentClass, (Map)JaxrsUtils.extractContracts(componentClass, JaxrsUtils.getOrder(componentClass)));
    }

    public ConfigurableImpl register(Class<?> componentClass, int priority) {
        if (componentClass == null) {
            return this;
        }
        return this.register((Class)componentClass, (Map)JaxrsUtils.extractContracts(componentClass, priority));
    }

    public ConfigurableImpl register(Class<?> componentClass, Class<?> ... contracts) {
        if (componentClass == null || contracts == null || contracts.length == 0) {
            return this;
        }
        this.configuration.addProviderClass(componentClass, this.checkContracts(componentClass, contracts));
        return this;
    }

    public ConfigurableImpl register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        if (componentClass == null || contracts == null || contracts.isEmpty()) {
            return this;
        }
        this.configuration.addProviderClass(componentClass, contracts);
        return this;
    }

    public ConfigurableImpl register(Object component) {
        if (component == null) {
            return this;
        }
        return this.register(component, (Map)JaxrsUtils.extractContracts(component, JaxrsUtils.getOrder(component)));
    }

    public ConfigurableImpl register(Object component, int priority) {
        if (component == null) {
            return this;
        }
        return this.register(component, (Map)JaxrsUtils.extractContracts(component, priority));
    }

    public ConfigurableImpl register(Object component, Class<?> ... contracts) {
        if (component == null || contracts == null || contracts.length == 0) {
            return this;
        }
        this.configuration.addProviderInstance(component, this.checkContracts(ClassUtils.getUserType((Object)component), contracts));
        return this;
    }

    public ConfigurableImpl register(Object component, Map<Class<?>, Integer> contracts) {
        if (component == null || contracts == null || contracts.isEmpty()) {
            return this;
        }
        this.configuration.addProviderInstance(component, contracts);
        return this;
    }

    private Map<Class<?>, Integer> checkContracts(Class<?> target, Class<?> ... contracts) {
        int order = JaxrsUtils.getOrder(target);
        HashMap checked = new HashMap();
        for (Class<?> contract : contracts) {
            if (!contract.isAssignableFrom(target)) {
                logger.warn("Failed to register {} as {}", target, contract);
                continue;
            }
            checked.put(contract, order);
        }
        return checked;
    }
}

