/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.container;

import esa.commons.Checks;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.core.handler.HandlerFactory;
import jakarta.ws.rs.container.ResourceContext;

public class ResourceContextImpl
implements ResourceContext {
    private final HandlerFactory underlying;
    private final RequestContext context;

    public ResourceContextImpl(HandlerFactory underlying, RequestContext context) {
        Checks.checkNotNull((Object)underlying, (String)"underlying");
        Checks.checkNotNull((Object)context, (String)"context");
        this.underlying = underlying;
        this.context = context;
    }

    public <T> T getResource(Class<T> resourceClass) {
        return (T)this.underlying.getInstance(resourceClass, this.context);
    }

    public <T> T initResource(T resource) {
        this.underlying.doInit(resource, this.context);
        return resource;
    }
}

