/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.container;

import esa.commons.Checks;
import esa.commons.ClassUtils;
import io.esastack.restlight.jaxrs.impl.core.ResponseImpl;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ContainerResponseContextImpl
implements ContainerResponseContext {
    private final ResponseImpl response;
    private OutputStream outputStream;

    public ContainerResponseContextImpl(OutputStream outputStream, ResponseImpl response) {
        Checks.checkNotNull((Object)outputStream, (String)"outputStream");
        Checks.checkNotNull((Object)((Object)response), (String)"response");
        this.outputStream = outputStream;
        this.response = response;
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public void setStatus(int code) {
        this.response.setStatus(code);
    }

    public Response.StatusType getStatusInfo() {
        return this.response.getStatusInfo();
    }

    public void setStatusInfo(Response.StatusType statusInfo) {
        this.response.setStatus(statusInfo);
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.response.getHeaders();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.response.getStringHeaders();
    }

    public String getHeaderString(String name) {
        return this.response.getHeaderString(name);
    }

    public Set<String> getAllowedMethods() {
        return this.response.getAllowedMethods();
    }

    public Date getDate() {
        return this.response.getDate();
    }

    public Locale getLanguage() {
        return this.response.getLanguage();
    }

    public int getLength() {
        return this.response.getLength();
    }

    public MediaType getMediaType() {
        return this.response.getMediaType();
    }

    public Map<String, NewCookie> getCookies() {
        return this.response.getCookies();
    }

    public EntityTag getEntityTag() {
        return this.response.getEntityTag();
    }

    public Date getLastModified() {
        return this.response.getLastModified();
    }

    public URI getLocation() {
        return this.response.getLocation();
    }

    public Set<Link> getLinks() {
        return this.response.getLinks();
    }

    public boolean hasLink(String relation) {
        return this.response.hasLink(relation);
    }

    public Link getLink(String relation) {
        return this.response.getLink(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        return this.response.getLinkBuilder(relation);
    }

    public boolean hasEntity() {
        return this.response.hasEntity();
    }

    public Object getEntity() {
        return this.response.getEntity();
    }

    public Class<?> getEntityClass() {
        return ClassUtils.getUserType((Object)this.getEntity());
    }

    public Type getEntityType() {
        return ClassUtils.getRawType(this.getEntityClass());
    }

    public void setEntity(Object entity) {
        this.response.setEntity(entity);
    }

    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.response.setEntity(entity, annotations, mediaType);
    }

    public Annotation[] getEntityAnnotations() {
        return this.response.getAnnotations();
    }

    public OutputStream getEntityStream() {
        return this.outputStream;
    }

    public void setEntityStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

