/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.container;

import esa.commons.Checks;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.TimeoutHandler;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public class AsyncResponseImpl
implements AsyncResponse {
    private static final UnsupportedOperationException UNSUPPORTED_REGISTRATION = new UnsupportedOperationException("registration operation is unsupported.");
    private static final Timer TIME_OUT_SCHEDULER = new HashedWheelTimer();
    private static final AtomicIntegerFieldUpdater<AsyncResponseImpl> STATUS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AsyncResponseImpl.class, "state");
    private final CompletableFuture<Object> asyncResponse;
    private final ReentrantLock handlerLock = new ReentrantLock();
    private final AtomicReference<TimeoutTask> timeoutTask = new AtomicReference();
    private volatile int state = AsyncState.access$000(AsyncState.SUSPENDED);

    public AsyncResponseImpl(CompletionStage<Object> asyncResponse) {
        Checks.checkNotNull(asyncResponse, (String)"asyncResponse");
        this.asyncResponse = asyncResponse.toCompletableFuture();
    }

    public boolean resume(Object response) {
        if (STATUS_UPDATER.compareAndSet(this, AsyncState.SUSPENDED.code, AsyncState.RESUMED.code)) {
            if (response instanceof Throwable) {
                this.asyncResponse.completeExceptionally((Throwable)response);
            } else {
                this.asyncResponse.complete(response);
            }
            return true;
        }
        return false;
    }

    public boolean resume(Throwable response) {
        if (STATUS_UPDATER.compareAndSet(this, AsyncState.SUSPENDED.code, AsyncState.RESUMED.code)) {
            this.asyncResponse.completeExceptionally(response);
            return true;
        }
        return false;
    }

    public boolean cancel() {
        if (AsyncState.CANCELLED.code == STATUS_UPDATER.get(this)) {
            return true;
        }
        if (STATUS_UPDATER.compareAndSet(this, AsyncState.SUSPENDED.code, AsyncState.CANCELLED.code)) {
            this.doCancel(null);
            return true;
        }
        return false;
    }

    public boolean cancel(int retryAfter) {
        if (AsyncState.CANCELLED.code == STATUS_UPDATER.get(this)) {
            return true;
        }
        if (STATUS_UPDATER.compareAndSet(this, AsyncState.SUSPENDED.code, AsyncState.CANCELLED.code)) {
            this.doCancel(retryAfter);
            return true;
        }
        return false;
    }

    public boolean cancel(Date retryAfter) {
        if (AsyncState.CANCELLED.code == STATUS_UPDATER.get(this)) {
            return true;
        }
        if (STATUS_UPDATER.compareAndSet(this, AsyncState.SUSPENDED.code, AsyncState.CANCELLED.code)) {
            this.doCancel(retryAfter);
            return true;
        }
        return false;
    }

    public boolean isSuspended() {
        return AsyncState.SUSPENDED.code == STATUS_UPDATER.get(this);
    }

    public boolean isCancelled() {
        return AsyncState.CANCELLED.code == STATUS_UPDATER.get(this);
    }

    public boolean isDone() {
        return this.asyncResponse.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTimeout(long time, TimeUnit unit) {
        if (!this.isSuspended()) {
            return false;
        }
        this.handlerLock.lock();
        try {
            TimeoutTask task = this.timeoutTask.get();
            if (task != null && task.task != null) {
                task.task.cancel();
            }
            Timeout newTimeoutTask = time <= 0L ? null : TIME_OUT_SCHEDULER.newTimeout(timeout -> {
                TimeoutTask t;
                if (!timeout.isCancelled() && (t = this.timeoutTask.get()) != null && t.handler != null) {
                    block3: {
                        try {
                            t.handler.handleTimeout((AsyncResponse)this);
                            this.completeResponse(null);
                        }
                        catch (Throwable th) {
                            if (this.asyncResponse.isDone()) break block3;
                            this.asyncResponse.completeExceptionally(th);
                        }
                    }
                    this.timeoutTask.updateAndGet(pre -> new TimeoutTask(t.timeout, t.unit, t.handler, null));
                }
            }, time, unit);
            this.timeoutTask.updateAndGet(pre -> new TimeoutTask(time, unit, task != null ? task.handler : null, newTimeoutTask));
        }
        finally {
            this.handlerLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeoutHandler(TimeoutHandler handler) {
        this.handlerLock.lock();
        try {
            TimeoutTask task = this.timeoutTask.get();
            TimeoutTask newTask = task != null ? new TimeoutTask(task.timeout, task.unit, handler, task.task) : new TimeoutTask(0L, TimeUnit.MICROSECONDS, handler, null);
            this.timeoutTask.updateAndGet(pre -> newTask);
        }
        finally {
            this.handlerLock.unlock();
        }
    }

    public Collection<Class<?>> register(Class<?> callback) {
        throw UNSUPPORTED_REGISTRATION;
    }

    public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) {
        throw UNSUPPORTED_REGISTRATION;
    }

    public Collection<Class<?>> register(Object callback) {
        throw UNSUPPORTED_REGISTRATION;
    }

    public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) {
        throw UNSUPPORTED_REGISTRATION;
    }

    TimeoutTask timeoutTask() {
        return this.timeoutTask.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancel(Object retryAfter) {
        this.handlerLock.lock();
        try {
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE);
            if (retryAfter != null) {
                builder.header("Retry-After", retryAfter);
            }
            this.completeResponse(builder.build());
            TimeoutTask task = this.timeoutTask.get();
            if (task != null && task.task != null) {
                task.task.cancel();
                this.timeoutTask.getAndSet(new TimeoutTask(task.timeout, task.unit, task.handler, null));
            }
        }
        finally {
            this.handlerLock.unlock();
        }
    }

    private void completeResponse(Object response) {
        if (!this.asyncResponse.isDone()) {
            this.asyncResponse.complete(response);
        }
    }

    static class TimeoutTask {
        final long timeout;
        final TimeUnit unit;
        final TimeoutHandler handler;
        final Timeout task;

        private TimeoutTask(long timeout, TimeUnit unit, TimeoutHandler handler, Timeout task) {
            this.timeout = timeout;
            this.unit = unit;
            this.handler = handler;
            this.task = task;
        }
    }

    private static enum AsyncState {
        SUSPENDED(0),
        RESUMED(1),
        CANCELLED(2);

        private final byte code;

        private AsyncState(byte code) {
            this.code = code;
        }
    }
}

