/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl.container;

import esa.commons.Checks;
import esa.commons.collection.AttributeKey;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.jaxrs.impl.JaxrsContextUtils;
import io.esastack.restlight.jaxrs.impl.core.ModifiableMultivaluedMap;
import io.esastack.restlight.jaxrs.impl.core.UriInfoImpl;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractContainerRequestContext
implements ContainerRequestContext {
    final RequestContext context;
    final UriInfoImpl uriInfo;
    private final Request request;
    private final HttpHeaders headers;
    private volatile boolean aborted;

    public AbstractContainerRequestContext(RequestContext context) {
        Checks.checkNotNull((Object)context, (String)"context");
        this.context = context;
        this.request = JaxrsContextUtils.getRequest(context);
        this.uriInfo = JaxrsContextUtils.getUriInfo(context);
        this.headers = JaxrsContextUtils.getHeaders(context);
    }

    public Object getProperty(String name) {
        return this.context.attrs().attr(AttributeKey.valueOf((String)name)).get();
    }

    public Collection<String> getPropertyNames() {
        ArrayList names = new ArrayList(this.context.attrs().size());
        this.context.attrs().forEach((name, value) -> {
            if (value.get() != null) {
                names.add(name.name());
            }
        });
        return Collections.unmodifiableList(names);
    }

    public void setProperty(String name, Object object) {
        if (object == null) {
            this.removeProperty(name);
        } else {
            this.context.attrs().attr(AttributeKey.valueOf((String)name)).set(object);
        }
    }

    public void removeProperty(String name) {
        this.context.attrs().attr(AttributeKey.valueOf((String)name)).remove();
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public Request getRequest() {
        return this.request;
    }

    public String getMethod() {
        return this.context.request().method().name();
    }

    public MultivaluedMap<String, String> getHeaders() {
        return new ModifiableMultivaluedMap(this.context.request().headers());
    }

    public String getHeaderString(String name) {
        return this.headers.getHeaderString(name);
    }

    public Date getDate() {
        return this.headers.getDate();
    }

    public Locale getLanguage() {
        return this.headers.getLanguage();
    }

    public List<Locale> getAcceptableLanguages() {
        return this.headers.getAcceptableLanguages();
    }

    public int getLength() {
        return (int)this.context.request().contentLength();
    }

    public MediaType getMediaType() {
        return this.headers.getMediaType();
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return this.headers.getAcceptableMediaTypes();
    }

    public Map<String, Cookie> getCookies() {
        return this.headers.getCookies();
    }

    public boolean hasEntity() {
        return this.context.request().body().readableBytes() > 0;
    }

    public InputStream getEntityStream() {
        return this.context.request().inputStream();
    }

    public SecurityContext getSecurityContext() {
        return JaxrsContextUtils.getSecurityContext(this.context);
    }

    public void setSecurityContext(SecurityContext context) {
        JaxrsContextUtils.setSecurityContext(this.context, context);
    }

    public void abortWith(Response response) {
        this.aborted = true;
        this.context.response().entity((Object)response);
    }

    public boolean isAborted() {
        return this.aborted;
    }
}

