/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.impl;

import esa.commons.collection.AttributeKey;
import io.esastack.restlight.core.context.HttpRequest;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.core.filter.FilterContext;
import io.esastack.restlight.jaxrs.impl.container.AbstractContainerRequestContext;
import io.esastack.restlight.jaxrs.impl.container.PostMatchContainerRequestContext;
import io.esastack.restlight.jaxrs.impl.container.PreMatchContainerRequestContext;
import io.esastack.restlight.jaxrs.impl.core.HttpRequestHeaders;
import io.esastack.restlight.jaxrs.impl.core.RequestImpl;
import io.esastack.restlight.jaxrs.impl.core.UriInfoImpl;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.SecurityContext;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class JaxrsContextUtils {
    private static final AttributeKey<Request> REQUEST_KEY = AttributeKey.valueOf((String)"$jakarta.request");
    private static final AttributeKey<UriInfoImpl> URI_KEY = AttributeKey.valueOf((String)"$jakarta.uriInfo");
    private static final AttributeKey<HttpHeaders> REQUEST_HEADERS_KEY = AttributeKey.valueOf((String)"$jakarta.request.headers");
    private static final AttributeKey<SecurityContext> SECURITY_CONTEXT_KEY = AttributeKey.valueOf((String)"$jakarta.security.context");
    private static final AttributeKey<AbstractContainerRequestContext> REQUEST_CONTEXT_KEY = AttributeKey.valueOf((String)"$jakarta.request.context");
    private static final AttributeKey<CompletableFuture<Object>> ASYNC_RESPONSE_KEY = AttributeKey.valueOf((String)"$jakarta.async.response");

    public static Request getRequest(RequestContext context) {
        Request request = (Request)context.attrs().attr(REQUEST_KEY).get();
        if (request == null) {
            request = new RequestImpl(context);
            context.attrs().attr(REQUEST_KEY).set((Object)request);
        }
        return request;
    }

    public static UriInfoImpl getUriInfo(RequestContext context) {
        UriInfoImpl uriInfo = (UriInfoImpl)context.attrs().attr(URI_KEY).get();
        if (uriInfo == null) {
            uriInfo = new UriInfoImpl(JaxrsContextUtils.extractURI(context), context);
            context.attrs().attr(URI_KEY).set((Object)uriInfo);
        }
        return uriInfo;
    }

    public static HttpHeaders getHeaders(RequestContext context) {
        HttpHeaders headers = (HttpHeaders)context.attrs().attr(REQUEST_HEADERS_KEY).get();
        if (headers == null) {
            headers = new HttpRequestHeaders(context.request());
            context.attrs().attr(REQUEST_HEADERS_KEY).set((Object)headers);
        }
        return headers;
    }

    public static AbstractContainerRequestContext getRequestContext(RequestContext context) {
        AbstractContainerRequestContext ctx = (AbstractContainerRequestContext)context.attrs().attr(REQUEST_CONTEXT_KEY).get();
        if (ctx == null) {
            ctx = context instanceof FilterContext ? new PreMatchContainerRequestContext((FilterContext)context) : new PostMatchContainerRequestContext(context);
            context.attrs().attr(REQUEST_CONTEXT_KEY).set((Object)ctx);
        }
        return ctx;
    }

    public static SecurityContext getSecurityContext(RequestContext context) {
        return (SecurityContext)context.attrs().attr(SECURITY_CONTEXT_KEY).get();
    }

    public static void setSecurityContext(RequestContext context, SecurityContext sCtx) {
        context.attrs().attr(SECURITY_CONTEXT_KEY).set((Object)sCtx);
    }

    public static void setAsyncResponse(RequestContext context, CompletionStage<Object> response) {
        context.attrs().attr(ASYNC_RESPONSE_KEY).set(response.toCompletableFuture());
    }

    public static CompletionStage<Object> getAsyncResponse(RequestContext context) {
        return (CompletionStage)context.attrs().attr(ASYNC_RESPONSE_KEY).get();
    }

    public static URI extractURI(RequestContext context) {
        HttpRequest request = context.request();
        StringBuilder sb = new StringBuilder();
        sb.append(request.scheme().toLowerCase()).append("://").append(request.localAddr()).append(":").append(request.localPort());
        return URI.create(sb.toString());
    }

    private JaxrsContextUtils() {
    }
}

