/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.configure;

import esa.commons.Checks;
import esa.commons.ClassUtils;
import io.esastack.restlight.core.DeployContext;
import io.esastack.restlight.jaxrs.configure.ExtensionHandlerProxy;
import io.esastack.restlight.jaxrs.configure.LazyInjectHandler;
import io.esastack.restlight.jaxrs.configure.LazyInstantiateHandler;
import io.esastack.restlight.jaxrs.configure.ProvidersFactory;
import io.esastack.restlight.jaxrs.configure.ProxyComponent;
import io.esastack.restlight.jaxrs.impl.core.ConfigurationImpl;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ProvidersFactoryImpl
implements ProvidersFactory {
    private final DeployContext context;
    private final ConfigurationImpl configuration;

    public ProvidersFactoryImpl(DeployContext context, ConfigurationImpl configuration) {
        Checks.checkNotNull((Object)context, (String)"context");
        Checks.checkNotNull((Object)configuration, (String)"configuration");
        this.context = context;
        this.configuration = configuration;
    }

    @Override
    public Collection<ProxyComponent<MessageBodyReader<?>>> messageBodyReaders() {
        LinkedList readers = new LinkedList();
        this.getFromClasses(this.configuration.getProviderClasses(), MessageBodyReader.class).values().forEach(component -> readers.add(new ProxyComponent<MessageBodyReader>(component.underlying(), (MessageBodyReader)component.proxied())));
        this.getFromInstances(this.configuration.getProviderInstances(), MessageBodyReader.class).values().forEach(component -> readers.add(new ProxyComponent<MessageBodyReader>(component.underlying(), (MessageBodyReader)component.proxied())));
        return Collections.unmodifiableList(readers);
    }

    @Override
    public Collection<ProxyComponent<MessageBodyWriter<?>>> messageBodyWriters() {
        LinkedList writers = new LinkedList();
        this.getFromClasses(this.configuration.getProviderClasses(), MessageBodyWriter.class).values().forEach(component -> writers.add(new ProxyComponent<MessageBodyWriter>(component.underlying(), (MessageBodyWriter)component.proxied())));
        this.getFromInstances(this.configuration.getProviderInstances(), MessageBodyWriter.class).values().forEach(component -> writers.add(new ProxyComponent<MessageBodyWriter>(component.underlying(), (MessageBodyWriter)component.proxied())));
        return Collections.unmodifiableList(writers);
    }

    @Override
    public Collection<ProxyComponent<ExceptionMapper<Throwable>>> exceptionMappers() {
        LinkedList mappers = new LinkedList();
        this.getFromClasses(this.configuration.getProviderClasses(), ExceptionMapper.class).forEach((clazz, instance) -> mappers.add(new ProxyComponent<ExceptionMapper>(instance.underlying(), (ExceptionMapper)instance.proxied())));
        this.getFromInstances(this.configuration.getProviderInstances(), ExceptionMapper.class).forEach((clazz, instance) -> mappers.add(new ProxyComponent<ExceptionMapper>(instance.underlying(), (ExceptionMapper)instance.proxied())));
        return Collections.unmodifiableList(mappers);
    }

    @Override
    public Collection<ProxyComponent<ContextResolver<?>>> contextResolvers() {
        LinkedList resolvers = new LinkedList();
        this.getFromClasses(this.configuration.getProviderClasses(), ContextResolver.class).forEach((clazz, instance) -> resolvers.add(new ProxyComponent<ContextResolver>(instance.underlying(), (ContextResolver)instance.proxied())));
        this.getFromInstances(this.configuration.getProviderInstances(), ContextResolver.class).forEach((clazz, instance) -> resolvers.add(new ProxyComponent<ContextResolver>(instance.underlying(), (ContextResolver)instance.proxied())));
        return Collections.unmodifiableList(resolvers);
    }

    @Override
    public Collection<ProxyComponent<Feature>> features() {
        LinkedList<ProxyComponent<Feature>> features = new LinkedList<ProxyComponent<Feature>>();
        features.addAll(this.getFromClasses(this.configuration.getProviderClasses(), Feature.class).values());
        features.addAll(this.getFromInstances(this.configuration.getProviderInstances(), Feature.class).values());
        return Collections.unmodifiableList(features);
    }

    @Override
    public Collection<ProxyComponent<ParamConverterProvider>> paramConverterProviders() {
        LinkedList<ProxyComponent<ParamConverterProvider>> providers = new LinkedList<ProxyComponent<ParamConverterProvider>>();
        providers.addAll(this.getFromClasses(this.configuration.getProviderClasses(), ParamConverterProvider.class).values());
        providers.addAll(this.getFromInstances(this.configuration.getProviderInstances(), ParamConverterProvider.class).values());
        return Collections.unmodifiableList(providers);
    }

    @Override
    public Collection<ProxyComponent<DynamicFeature>> dynamicFeatures() {
        LinkedList<ProxyComponent<DynamicFeature>> dynamicFeatures = new LinkedList<ProxyComponent<DynamicFeature>>();
        dynamicFeatures.addAll(this.getFromClasses(this.configuration.getProviderClasses(), DynamicFeature.class).values());
        dynamicFeatures.addAll(this.getFromInstances(this.configuration.getProviderInstances(), DynamicFeature.class).values());
        return Collections.unmodifiableList(dynamicFeatures);
    }

    @Override
    public Collection<ProxyComponent<ReaderInterceptor>> readerInterceptors() {
        LinkedList<ProxyComponent<ReaderInterceptor>> interceptors = new LinkedList<ProxyComponent<ReaderInterceptor>>();
        interceptors.addAll(this.getFromClasses(this.configuration.getProviderClasses(), ReaderInterceptor.class).values());
        interceptors.addAll(this.getFromInstances(this.configuration.getProviderInstances(), ReaderInterceptor.class).values());
        return Collections.unmodifiableList(interceptors);
    }

    @Override
    public Collection<ProxyComponent<WriterInterceptor>> writerInterceptors() {
        LinkedList<ProxyComponent<WriterInterceptor>> interceptors = new LinkedList<ProxyComponent<WriterInterceptor>>();
        interceptors.addAll(this.getFromClasses(this.configuration.getProviderClasses(), WriterInterceptor.class).values());
        interceptors.addAll(this.getFromInstances(this.configuration.getProviderInstances(), WriterInterceptor.class).values());
        return Collections.unmodifiableList(interceptors);
    }

    @Override
    public Collection<ProxyComponent<ContainerRequestFilter>> requestFilters() {
        LinkedList<ProxyComponent<ContainerRequestFilter>> filters = new LinkedList<ProxyComponent<ContainerRequestFilter>>();
        filters.addAll(this.getFromClasses(this.configuration.getProviderClasses(), ContainerRequestFilter.class).values());
        filters.addAll(this.getFromInstances(this.configuration.getProviderInstances(), ContainerRequestFilter.class).values());
        return Collections.unmodifiableList(filters);
    }

    @Override
    public Collection<ProxyComponent<ContainerResponseFilter>> responseFilters() {
        LinkedList<ProxyComponent<ContainerResponseFilter>> filters = new LinkedList<ProxyComponent<ContainerResponseFilter>>();
        filters.addAll(this.getFromClasses(this.configuration.getProviderClasses(), ContainerResponseFilter.class).values());
        filters.addAll(this.getFromInstances(this.configuration.getProviderInstances(), ContainerResponseFilter.class).values());
        return Collections.unmodifiableList(filters);
    }

    protected <T> Map<Class<?>, ProxyComponent<T>> getFromClasses(Collection<Class<?>> classes, Class<T> target) {
        HashMap values = new HashMap();
        for (Class<?> clazz : classes) {
            if (!target.isAssignableFrom(clazz)) continue;
            values.put(clazz, new ProxyComponent<Object>(clazz, ExtensionHandlerProxy.newProxy(target, new LazyInstantiateHandler(this.context, clazz))));
        }
        return values;
    }

    protected <T> Map<Class<?>, ProxyComponent<T>> getFromInstances(Collection<Object> instances, Class<T> target) {
        HashMap values = new HashMap();
        for (Object instance : instances) {
            Class userType = ClassUtils.getUserType((Object)instance);
            if (!target.isAssignableFrom(userType)) continue;
            values.put(userType, new ProxyComponent<Object>(instance, ExtensionHandlerProxy.newProxy(target, new LazyInjectHandler(this.context, instance))));
        }
        return values;
    }
}

