/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.configure;

import esa.commons.Checks;
import io.esastack.restlight.core.DeployContext;
import io.esastack.restlight.core.handler.HandlerFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class LazyInstantiateHandler
implements InvocationHandler {
    private final DeployContext context;
    private final Class<?> clazz;
    private volatile Object target;
    private volatile boolean initialized;

    LazyInstantiateHandler(DeployContext context, Class<?> clazz) {
        Checks.checkNotNull((Object)context, (String)"context");
        Checks.checkNotNull(clazz, (String)"clazz");
        this.clazz = clazz;
        this.context = context;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.getInstanceThenInit(), args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getInstanceThenInit() {
        Object instance = this.getInstance();
        if (!this.initialized) {
            LazyInstantiateHandler lazyInstantiateHandler = this;
            synchronized (lazyInstantiateHandler) {
                if (!this.initialized) {
                    ((HandlerFactory)this.context.handlerFactory().orElseThrow(() -> new IllegalStateException("HandlerFactory is not present while initializing object, clazz: " + this.clazz))).doInit(instance, null);
                    this.initialized = true;
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getInstance() {
        if (this.target != null) {
            return this.target;
        }
        LazyInstantiateHandler lazyInstantiateHandler = this;
        synchronized (lazyInstantiateHandler) {
            if (this.target == null) {
                this.target = ((HandlerFactory)this.context.handlerFactory().orElseThrow(() -> new IllegalStateException("HandlerFactory is not present while instantiating class: " + this.clazz))).instantiate(this.clazz, null);
            }
        }
        return this.target;
    }
}

