/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.restlight.jaxrs.configure;

import esa.commons.Checks;
import esa.commons.ObjectUtils;
import esa.commons.reflect.BeanUtils;
import esa.commons.reflect.ReflectionUtils;
import io.esastack.restlight.core.DeployContext;
import io.esastack.restlight.core.context.RequestContext;
import io.esastack.restlight.core.exception.WebServerException;
import io.esastack.restlight.core.handler.Handlers;
import io.esastack.restlight.core.handler.impl.HandlerContext;
import io.esastack.restlight.core.handler.impl.HandlerFactoryImpl;
import io.esastack.restlight.core.handler.method.ConstructorParam;
import io.esastack.restlight.core.handler.method.ConstructorParamImpl;
import io.esastack.restlight.core.handler.method.FieldParam;
import io.esastack.restlight.core.handler.method.FieldParamImpl;
import io.esastack.restlight.core.handler.method.MethodParam;
import io.esastack.restlight.core.handler.method.MethodParamImpl;
import io.esastack.restlight.core.handler.method.Param;
import io.esastack.restlight.core.handler.method.ResolvableParam;
import io.esastack.restlight.core.handler.method.ResolvableParamPredicate;
import io.esastack.restlight.core.resolver.context.ContextResolver;
import io.esastack.restlight.core.resolver.context.ContextResolverContext;
import io.esastack.restlight.core.resolver.context.ContextResolverContextImpl;
import io.esastack.restlight.core.resolver.factory.HandlerResolverFactory;
import io.esastack.restlight.core.util.ConstructorUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;

public class JaxrsHandlerFactory
extends HandlerFactoryImpl {
    private final ConcurrentHashMap<Class<?>, ResolvableProvider> resolvableProviders = new ConcurrentHashMap();
    private static final ContextResolverContext DEFAULT_CONTEXT = new ContextResolverContextImpl();

    public JaxrsHandlerFactory(DeployContext defaultContext, Handlers handlers) {
        super(defaultContext, handlers);
    }

    protected Object doInstantiate(HandlerContext handlerContext, Class<?> clazz, RequestContext context) {
        if (context != null) {
            return super.doInstantiate(handlerContext, clazz, context);
        }
        if (!handlerContext.resolverFactory().isPresent()) {
            return ObjectUtils.instantiateBeanIfNecessary(clazz);
        }
        ResolvableProvider resolvable = this.getResolvableProvider(clazz, (DeployContext)handlerContext);
        Object[] consArgs = new Object[resolvable.constructor.getParameterCount()];
        ResolvableParam[] consParams = resolvable.consParamResolvers;
        int index = 0;
        for (ResolvableParam param : consParams) {
            try {
                consArgs[index++] = ((ContextResolver)param.resolver()).resolve(DEFAULT_CONTEXT);
            }
            catch (Throwable th) {
                throw WebServerException.wrap((Throwable)th);
            }
        }
        try {
            return resolvable.constructor.newInstance(consArgs);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException("Could not instantiate provider class: [" + clazz + "]", ex.getTargetException());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not instantiate provider class: [" + clazz + "]", ex);
        }
    }

    protected void doInit0(HandlerContext handlerContext, Object instance, Class<?> clazz, RequestContext context) {
        if (context != null) {
            super.doInit0(handlerContext, instance, clazz, context);
        } else {
            MethodParam param;
            if (!handlerContext.resolverFactory().isPresent()) {
                return;
            }
            ResolvableProvider resolvable = this.getResolvableProvider(clazz, (DeployContext)handlerContext);
            for (ResolvableParam r : resolvable.setterParamResolvers) {
                param = (MethodParam)r.param();
                if (r.resolver() == null) continue;
                try {
                    Object arg = ((ContextResolver)r.resolver()).resolve(DEFAULT_CONTEXT);
                    ReflectionUtils.invokeMethod((Method)param.method(), (Object)instance, (Object[])new Object[]{arg});
                }
                catch (InvocationTargetException ex) {
                    throw new IllegalStateException("Failed to invoke method: [" + param.method() + "]", ex.getTargetException());
                }
                catch (Exception ex) {
                    throw WebServerException.wrap((Throwable)ex);
                }
            }
            for (ResolvableParam r : resolvable.fieldParamResolvers) {
                param = (FieldParam)r.param();
                if (r.resolver() == null) continue;
                try {
                    BeanUtils.setFieldValue((Object)instance, (String)param.name(), (Object)((ContextResolver)r.resolver()).resolve(DEFAULT_CONTEXT));
                }
                catch (Exception e) {
                    throw WebServerException.wrap((Throwable)e);
                }
            }
        }
    }

    private ResolvableProvider getResolvableProvider(Class<?> clazz, DeployContext context) {
        return this.resolvableProviders.computeIfAbsent(clazz, clz -> new ResolvableProvider(clazz, context));
    }

    private static class ResolvableProvider {
        private final Constructor<?> constructor;
        private final ResolvableParam<ConstructorParam, ContextResolver>[] consParamResolvers;
        private final ResolvableParam<MethodParam, ContextResolver>[] setterParamResolvers;
        private final ResolvableParam<FieldParam, ContextResolver>[] fieldParamResolvers;
        private final DeployContext context;

        private ResolvableProvider(Class<?> clazz, DeployContext context) {
            HandlerResolverFactory resolverFactory = (HandlerResolverFactory)context.resolverFactory().orElseThrow(() -> new IllegalStateException("resolverFactory is null"));
            ResolvableParamPredicate resolvable = (ResolvableParamPredicate)context.paramPredicate().orElseThrow(() -> new IllegalStateException("paramPredicate is null"));
            this.constructor = ConstructorUtils.extractResolvable(clazz, (ResolvableParamPredicate)resolvable);
            Checks.checkState((this.constructor != null ? 1 : 0) != 0, (String)("There is no suitable constructor to instantiate class: " + clazz.getName()));
            this.context = context;
            this.consParamResolvers = this.contextResolversOfCons(this.constructor, resolvable, resolverFactory);
            this.setterParamResolvers = this.contextResolversOfSetter(clazz, resolvable, resolverFactory);
            this.fieldParamResolvers = this.contextResolversOfField(clazz, resolvable, resolverFactory);
        }

        private ResolvableParam<ConstructorParam, ContextResolver>[] contextResolversOfCons(Constructor<?> constructor, ResolvableParamPredicate predicate, HandlerResolverFactory factory) {
            LinkedList<ResolvableParam> params = new LinkedList<ResolvableParam>();
            for (int i = 0; i < constructor.getParameterCount(); ++i) {
                ConstructorParamImpl param = new ConstructorParamImpl(constructor, i);
                if (!predicate.test((Param)param)) continue;
                params.add(new ResolvableParam((Param)param, (Object)factory.getContextResolver((Param)param)));
            }
            return params.toArray(new ResolvableParam[0]);
        }

        private ResolvableParam<MethodParam, ContextResolver>[] contextResolversOfSetter(Class<?> clazz, ResolvableParamPredicate predicate, HandlerResolverFactory factory) {
            LinkedList params = new LinkedList();
            ReflectionUtils.getAllDeclaredMethods(clazz).stream().filter(ReflectionUtils::isSetter).forEach(m -> {
                MethodParamImpl param = new MethodParamImpl(m, 0);
                if (predicate.test((Param)param)) {
                    params.add(new ResolvableParam((Param)param, (Object)factory.getContextResolver((Param)param)));
                }
            });
            return params.toArray(new ResolvableParam[0]);
        }

        private ResolvableParam<FieldParam, ContextResolver>[] contextResolversOfField(Class<?> clazz, ResolvableParamPredicate predicate, HandlerResolverFactory factory) {
            LinkedList params = new LinkedList();
            ReflectionUtils.getAllDeclaredFields(clazz).forEach(f -> {
                FieldParamImpl param = new FieldParamImpl(f);
                if (predicate.test((Param)param)) {
                    params.add(new ResolvableParam((Param)param, (Object)factory.getContextResolver((Param)param)));
                }
            });
            return params.toArray(new ResolvableParam[0]);
        }
    }
}

